/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.redis;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Generated;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.redis.exceptions.RedisEntryException;

public class RedisEntry {
    private final String serviceId;
    private final KeyValue entry;
    private final ObjectMapper mapper;

    public RedisEntry(String serviceId, KeyValue entry) {
        this.serviceId = serviceId;
        this.entry = entry;
        this.mapper = new ObjectMapper();
    }

    public RedisEntry(String serviceId, String redisValue) throws RedisEntryException {
        this.mapper = new ObjectMapper();
        this.serviceId = serviceId;
        try {
            this.entry = (KeyValue)this.mapper.readValue(redisValue, KeyValue.class);
        }
        catch (Exception e) {
            throw new RedisEntryException("Failure deserializing the entry to a KeyValue object", e);
        }
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public KeyValue getEntry() {
        return this.entry;
    }

    public String getEntryAsString() throws RedisEntryException {
        try {
            return this.mapper.writeValueAsString((Object)this.entry);
        }
        catch (Exception e) {
            throw new RedisEntryException("Failure serializing the entry as a String", e);
        }
    }

    @Generated
    public RedisEntry(String serviceId, KeyValue entry, ObjectMapper mapper) {
        this.serviceId = serviceId;
        this.entry = entry;
        this.mapper = mapper;
    }
}

