/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.redis;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.redis.RedisEntry;
import org.zowe.apiml.caching.service.redis.exceptions.RedisEntryException;
import org.zowe.apiml.caching.service.redis.exceptions.RedisOutOfMemoryException;
import org.zowe.apiml.caching.service.redis.exceptions.RetryableRedisException;
import org.zowe.apiml.message.log.ApimlLogger;

@Component
@ConditionalOnProperty(name={"caching.storage.mode"}, havingValue="redis")
public class RedisOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisOperator.class);
    private RedisClient redisClient;
    private StatefulRedisMasterReplicaConnection<String, String> redisConnection;
    private RedisAsyncCommands<String, String> redis;

    public RedisOperator(RedisClient redisClient, RedisURI redisUri, ApimlLogger apimlLog) {
        try {
            this.redisClient = redisClient;
            this.redisConnection = MasterReplica.connect((RedisClient)this.redisClient, (RedisCodec)StringCodec.UTF8, (RedisURI)redisUri);
            this.redis = this.redisConnection.async();
            log.info("Connected to Redis {}", (Object)redisUri);
        }
        catch (Exception e) {
            apimlLog.log("org.zowe.apiml.cache.errorInitializingStorage", new Object[]{"redis", e.getCause().getMessage(), e});
            System.exit(1);
        }
    }

    @PreDestroy
    public void closeConnection() {
        if (this.redisConnection != null) {
            this.redisConnection.close();
        }
        if (this.redisClient != null) {
            this.redisClient.shutdown();
        }
    }

    public boolean create(RedisEntry entryToAdd) throws RedisOutOfMemoryException {
        KeyValue toAdd = entryToAdd.getEntry();
        try {
            RedisFuture result = this.redis.hsetnx((Object)entryToAdd.getServiceId(), (Object)toAdd.getKey(), (Object)entryToAdd.getEntryAsString());
            return (Boolean)result.get();
        }
        catch (ExecutionException e) {
            this.handleWriteOperationExecutionException(e);
        }
        catch (InterruptedException e) {
            this.handleInterruptedException(e);
        }
        catch (RedisEntryException e) {
            return false;
        }
        return false;
    }

    public boolean update(RedisEntry entryToUpdate) throws RedisOutOfMemoryException {
        String serviceId = entryToUpdate.getServiceId();
        KeyValue toUpdate = entryToUpdate.getEntry();
        try {
            boolean exists = (Boolean)this.redis.hexists((Object)serviceId, (Object)toUpdate.getKey()).get();
            if (!exists) {
                return false;
            }
            boolean result = (Boolean)this.redis.hset((Object)serviceId, (Object)toUpdate.getKey(), (Object)entryToUpdate.getEntryAsString()).get();
            return !result;
        }
        catch (ExecutionException e) {
            this.handleWriteOperationExecutionException(e);
        }
        catch (InterruptedException e) {
            this.handleInterruptedException(e);
        }
        catch (RedisEntryException e) {
            return false;
        }
        return false;
    }

    public RedisEntry get(String serviceId, String key) {
        try {
            String result = (String)this.redis.hget((Object)serviceId, (Object)key).get();
            return new RedisEntry(serviceId, result);
        }
        catch (InterruptedException e) {
            this.handleInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw new RetryableRedisException(e);
        }
        catch (RedisEntryException e) {
            log.warn("Error retrieving entry: {}|{}. Error: {}", new Object[]{serviceId, key, e.getMessage()});
        }
        return null;
    }

    public List<RedisEntry> get(String serviceId) {
        try {
            Map result = (Map)this.redis.hgetall((Object)serviceId).get();
            return this.collectEntries(serviceId, result);
        }
        catch (InterruptedException e) {
            this.handleInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw new RetryableRedisException(e);
        }
        return Collections.emptyList();
    }

    private List<RedisEntry> collectEntries(String serviceId, Map<String, String> redisEntries) {
        ArrayList<RedisEntry> entries = new ArrayList<RedisEntry>();
        for (Map.Entry<String, String> entry : redisEntries.entrySet()) {
            try {
                entries.add(new RedisEntry(serviceId, entry.getValue()));
            }
            catch (RedisEntryException e) {
                log.warn("Error retrieving entry: {}|{}. Error: {}", new Object[]{serviceId, entry, e.getMessage()});
            }
        }
        return entries;
    }

    public boolean delete(String serviceId, String toDelete) {
        try {
            long recordsDeleted = (Long)this.redis.hdel((Object)serviceId, (Object[])new String[]{toDelete}).get();
            return recordsDeleted >= 1L;
        }
        catch (InterruptedException e) {
            this.handleInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw new RetryableRedisException(e);
        }
        return false;
    }

    public boolean delete(String serviceId) {
        try {
            long recordsDeleted = (Long)this.redis.del((Object[])new String[]{serviceId}).get();
            return recordsDeleted >= 1L;
        }
        catch (InterruptedException e) {
            this.handleInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw new RetryableRedisException(e);
        }
        return false;
    }

    private void handleWriteOperationExecutionException(ExecutionException e) throws RedisOutOfMemoryException {
        Throwable cause = e.getCause();
        if (cause instanceof RedisCommandExecutionException && cause.getMessage().contains("maxmemory")) {
            throw new RedisOutOfMemoryException(cause);
        }
        throw new RetryableRedisException(e);
    }

    private void handleInterruptedException(InterruptedException e) {
        Thread.currentThread().interrupt();
        throw new RetryableRedisException(e);
    }

    @Generated
    public RedisOperator(RedisClient redisClient, StatefulRedisMasterReplicaConnection<String, String> redisConnection, RedisAsyncCommands<String, String> redis) {
        this.redisClient = redisClient;
        this.redisConnection = redisConnection;
        this.redis = redis;
    }

    @Generated
    public RedisOperator() {
    }
}

