/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.infinispan.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.infinispan.lock.api.ClusteredLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.Messages;
import org.zowe.apiml.caching.service.Storage;
import org.zowe.apiml.caching.service.StorageException;
import org.zowe.apiml.models.AccessTokenContainer;

public class InfinispanStorage
implements Storage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InfinispanStorage.class);
    private final ConcurrentMap<String, KeyValue> cache;
    private final ConcurrentMap<String, Map<String, String>> tokenCache;
    private final ClusteredLock lock;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public InfinispanStorage(ConcurrentMap<String, KeyValue> cache, ConcurrentMap<String, Map<String, String>> tokenCache, ClusteredLock lock) {
        this.cache = cache;
        this.tokenCache = tokenCache;
        this.lock = lock;
    }

    @Override
    public KeyValue create(String serviceId, KeyValue toCreate) {
        toCreate.setServiceId(serviceId);
        log.info("Writing record: {}|{}|{}", new Object[]{serviceId, toCreate.getKey(), toCreate.getValue()});
        KeyValue serviceCache = this.cache.putIfAbsent(serviceId + toCreate.getKey(), toCreate);
        if (serviceCache != null) {
            throw new StorageException(Messages.DUPLICATE_KEY.getKey(), Messages.DUPLICATE_KEY.getStatus(), toCreate.getKey());
        }
        return null;
    }

    @Override
    public KeyValue storeMapItem(String serviceId, String mapKey, KeyValue toCreate) {
        CompletionStage complete = this.lock.tryLock(4L, TimeUnit.SECONDS).whenComplete((r, ex) -> {
            if (Boolean.TRUE.equals(r)) {
                try {
                    String cacheKey = serviceId + mapKey;
                    log.info("Storing the item into token cache: {} -> {}|{}", new Object[]{cacheKey, toCreate.getKey(), toCreate.getValue()});
                    HashMap<String, String> tokenCacheItem = (HashMap<String, String>)this.tokenCache.get(cacheKey);
                    if (tokenCacheItem == null) {
                        tokenCacheItem = new HashMap<String, String>();
                    }
                    tokenCacheItem.put(toCreate.getKey(), toCreate.getValue());
                    this.tokenCache.put(cacheKey, tokenCacheItem);
                }
                finally {
                    this.lock.unlock();
                }
            }
        });
        this.completeJoin((CompletableFuture<Boolean>)complete);
        return null;
    }

    @Override
    public Map<String, String> getAllMapItems(String serviceId, String mapKey) {
        log.info("Reading all records from token cache for service {} under the {} key.", (Object)serviceId, (Object)mapKey);
        return (Map)this.tokenCache.get(serviceId + mapKey);
    }

    @Override
    public Map<String, Map<String, String>> getAllMaps(String serviceId) {
        log.info("Reading all records from token cache for service {} ", (Object)serviceId);
        return this.tokenCache.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(serviceId)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(serviceId.length()), Map.Entry::getValue));
    }

    @Override
    public KeyValue read(String serviceId, String key) {
        log.info("Reading record for service {} under key {}", (Object)serviceId, (Object)key);
        KeyValue serviceCache = (KeyValue)this.cache.get(serviceId + key);
        if (serviceCache != null) {
            return serviceCache;
        }
        throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), key, serviceId);
    }

    @Override
    public KeyValue update(String serviceId, KeyValue toUpdate) {
        toUpdate.setServiceId(serviceId);
        log.info("Updating record for service {} under key {}", (Object)serviceId, (Object)toUpdate);
        KeyValue serviceCache = this.cache.put(serviceId + toUpdate.getKey(), toUpdate);
        if (serviceCache == null) {
            throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), toUpdate.getKey(), serviceId);
        }
        return toUpdate;
    }

    @Override
    public KeyValue delete(String serviceId, String toDelete) {
        log.info("Removing record for service {} under key {}", (Object)serviceId, (Object)toDelete);
        KeyValue entry = (KeyValue)this.cache.remove(serviceId + toDelete);
        if (entry != null) {
            return entry;
        }
        throw new StorageException(Messages.KEY_NOT_IN_CACHE.getKey(), Messages.KEY_NOT_IN_CACHE.getStatus(), toDelete, serviceId);
    }

    @Override
    public Map<String, KeyValue> readForService(String serviceId) {
        log.info("Reading all records for service {} ", (Object)serviceId);
        HashMap<String, KeyValue> result = new HashMap<String, KeyValue>();
        this.cache.forEach((key, value) -> {
            if (serviceId.equals(value.getServiceId())) {
                result.put(value.getKey(), (KeyValue)value);
            }
        });
        return result;
    }

    @Override
    public void deleteForService(String serviceId) {
        log.info("Removing all records for service {} ", (Object)serviceId);
        this.cache.forEach((key, value) -> {
            if (value.getServiceId().equals(serviceId)) {
                this.cache.remove(key);
            }
        });
    }

    @Override
    public void removeNonRelevantTokens(String serviceId, String mapKey) {
        CompletionStage complete = this.lock.tryLock(4L, TimeUnit.SECONDS).whenComplete((r, ex) -> {
            if (Boolean.TRUE.equals(r)) {
                try {
                    this.removeToken(serviceId, mapKey);
                }
                finally {
                    this.lock.unlock();
                }
            }
        });
        this.completeJoin((CompletableFuture<Boolean>)complete);
    }

    private void removeToken(String serviceId, String mapKey) {
        Map map = (Map)this.tokenCache.get(serviceId + mapKey);
        if (map != null && !map.isEmpty()) {
            Map<String, String> result = map.entrySet().stream().filter(entry -> {
                try {
                    AccessTokenContainer c = (AccessTokenContainer)objectMapper.readValue((String)entry.getValue(), AccessTokenContainer.class);
                    return !c.getExpiresAt().isBefore(LocalDateTime.now());
                }
                catch (JsonProcessingException e) {
                    log.error("Not able to parse invalidToken json value.", (Throwable)e);
                    return true;
                }
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.tokenCache.put(serviceId + mapKey, result);
        }
    }

    @Override
    public void removeNonRelevantRules(String serviceId, String mapKey) {
        CompletionStage complete = this.lock.tryLock(4L, TimeUnit.SECONDS).whenComplete((r, ex) -> {
            if (Boolean.TRUE.equals(r)) {
                try {
                    long timestamp = System.currentTimeMillis();
                    Map map = (Map)this.tokenCache.get(serviceId + mapKey);
                    if (map != null && !map.isEmpty()) {
                        Map<String, String> result = map.entrySet().stream().filter(entry -> {
                            long delta = timestamp - Long.parseLong((String)entry.getValue());
                            long deltaToDays = TimeUnit.MILLISECONDS.toDays(delta);
                            return deltaToDays <= 90L;
                        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                        this.tokenCache.put(serviceId + mapKey, result);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        });
        this.completeJoin((CompletableFuture<Boolean>)complete);
    }

    private void completeJoin(CompletableFuture<Boolean> complete) {
        try {
            complete.join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof StorageException) {
                throw (StorageException)e.getCause();
            }
            log.error("Unexpected error while acquiring the lock ", (Throwable)e);
            throw e;
        }
    }

    static {
        objectMapper.registerModule((Module)new JavaTimeModule());
    }
}

