/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.vsam;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.vsam.VsamFile;
import org.zowe.apiml.caching.service.vsam.VsamRecord;
import org.zowe.apiml.caching.service.vsam.VsamRecordException;
import org.zowe.apiml.caching.service.vsam.config.VsamConfig;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.zfile.ZFile;
import org.zowe.apiml.zfile.ZFileException;

@Service
public class VsamInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VsamInitializer.class);

    @Retryable(value={UnsupportedOperationException.class}, maxAttempts=10)
    public void storageWarmup(VsamConfig config, ApimlLogger apimlLogger) {
        try (VsamFile file = new VsamFile(config, VsamConfig.VsamOptions.WRITE, true, apimlLogger);){
            log.info("Vsam file open successful");
        }
    }

    public void warmUpVsamFile(ZFile zFile, VsamConfig vsamConfig) throws ZFileException, VsamRecordException {
        log.info("Warming up the vsam file by writing and deleting a record");
        log.info("VSAM file being used: {}", (Object)zFile.getActualFilename());
        VsamRecord vsamRec = new VsamRecord(vsamConfig, "delete", new KeyValue("me", "novalue"));
        log.info("Writing Record: {}", (Object)vsamRec);
        zFile.write(vsamRec.getBytes());
        boolean found = zFile.locate(vsamRec.getKeyBytes(), 3);
        log.info("Test record for deletion found: {}", (Object)found);
        if (found) {
            byte[] recBuf = new byte[vsamConfig.getRecordLength()];
            zFile.read(recBuf);
            zFile.delrec();
            log.info("Test record deleted.");
        }
    }
}

