/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.caching.service.infinispan.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.lock.EmbeddedClusteredLockManagerFactory;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.zowe.apiml.caching.model.KeyValue;
import org.zowe.apiml.caching.service.Storage;
import org.zowe.apiml.caching.service.infinispan.exception.InfinispanConfigException;
import org.zowe.apiml.caching.service.infinispan.storage.InfinispanStorage;
import org.zowe.apiml.security.SecurityUtils;

@Configuration
@ConfigurationProperties(value="caching.storage.infinispan")
@ConditionalOnProperty(name={"caching.storage.mode"}, havingValue="infinispan")
public class InfinispanConfig {
    private static final String KEYRING_PASSWORD = "password";
    @Value(value="${caching.storage.infinispan.initialHosts}")
    private String initialHosts;
    @Value(value="${caching.storage.infinispan.persistence.dataLocation}")
    private String dataLocation;
    @Value(value="${caching.storage.infinispan.persistence.indexLocation:index}")
    private String indexLocation;
    @Value(value="${server.ssl.keyStoreType}")
    private String keyStoreType;
    @Value(value="${server.ssl.keyStore}")
    private String keyStore;
    @Value(value="${server.ssl.keyStorePassword}")
    private String keyStorePass;
    @Value(value="${jgroups.bind.port}")
    private String port;
    @Value(value="${jgroups.bind.address}")
    private String address;
    @Value(value="${jgroups.keyExchange.port:7118}")
    private String keyExchangePort;

    @PostConstruct
    void updateKeyring() {
        if (SecurityUtils.isKeyring((String)this.keyStore)) {
            this.keyStore = SecurityUtils.formatKeyringUrl((String)this.keyStore);
            if (StringUtils.isBlank((CharSequence)this.keyStorePass)) {
                this.keyStorePass = KEYRING_PASSWORD;
            }
        }
    }

    @Bean
    DefaultCacheManager cacheManager(ResourceLoader resourceLoader) {
        ConfigurationBuilderHolder holder;
        System.setProperty("jgroups.tcpping.initial_hosts", this.initialHosts);
        System.setProperty("jgroups.bind.port", this.port);
        System.setProperty("jgroups.bind.address", this.address);
        System.setProperty("jgroups.keyExchange.port", this.keyExchangePort);
        System.setProperty("server.ssl.keyStoreType", this.keyStoreType);
        System.setProperty("server.ssl.keyStore", this.keyStore);
        System.setProperty("server.ssl.keyStorePassword", this.keyStorePass);
        try (InputStream configurationStream = resourceLoader.getResource("classpath:infinispan.xml").getInputStream();){
            holder = new ParserRegistry().parse(configurationStream, null, MediaType.APPLICATION_XML);
        }
        catch (IOException e) {
            throw new InfinispanConfigException("Can't read configuration file", e);
        }
        DefaultCacheManager cacheManager = new DefaultCacheManager(holder, true);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).encoding().mediaType("application/x-jboss-marshalling");
        ((SoftIndexFileStoreConfigurationBuilder)builder.persistence().passivation(true).addSoftIndexFileStore().shared(false)).dataLocation(this.dataLocation).indexLocation(this.indexLocation);
        ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).getOrCreateCache("zoweCache", builder.build());
        ((EmbeddedCacheManagerAdmin)cacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).getOrCreateCache("zoweInvalidatedTokenCache", builder.build());
        return cacheManager;
    }

    @Bean
    public ClusteredLock lock(DefaultCacheManager cacheManager) {
        ClusteredLockManager clm = EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)cacheManager);
        clm.defineLock("zoweInvalidatedTokenLock");
        return clm.get("zoweInvalidatedTokenLock");
    }

    @Bean
    public Storage storage(DefaultCacheManager cacheManager, ClusteredLock clusteredLock) {
        return new InfinispanStorage((ConcurrentMap<String, KeyValue>)cacheManager.getCache("zoweCache"), (ConcurrentMap<String, Map<String, String>>)cacheManager.getCache("zoweInvalidatedTokenCache"), clusteredLock);
    }
}

