/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.multiplexed.multiplexer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.multiplexed.multiplexer.IMultiplexer;

public final class DefaultMultiplexer
implements IMultiplexer {
    private static final Logger LOG = Logger.getLogger(DefaultMultiplexer.class.getName());
    private static byte VERSION = 1;
    private static final byte PIPELINE_OPENED = 0;
    private static final byte PIPELINE_CLOSED = 1;
    private static final byte PIPELINE_DATA = 99;

    public String openPipeline(INonBlockingConnection connection) throws IOException, ClosedChannelException {
        UUID uuid = UUID.randomUUID();
        String pipelineId = uuid.toString();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + connection.getId() + "] sending on pipeline " + pipelineId + " opened notification");
        }
        IConnection.FlushMode flushMode = connection.getFlushmode();
        connection.setFlushmode(IConnection.FlushMode.ASYNC);
        ByteBuffer header = ByteBuffer.allocate(22);
        header.putInt(18);
        header.put(VERSION);
        header.put((byte)0);
        header.putLong(uuid.getMostSignificantBits());
        header.putLong(uuid.getLeastSignificantBits());
        header.rewind();
        connection.write(header);
        connection.flush();
        connection.setFlushmode(flushMode);
        return pipelineId;
    }

    public void closePipeline(INonBlockingConnection connection, String pipelineId) throws IOException, ClosedChannelException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + connection.getId() + "] sending on pipeline " + pipelineId + " closed notification");
        }
        IConnection.FlushMode flushMode = connection.getFlushmode();
        connection.setFlushmode(IConnection.FlushMode.ASYNC);
        UUID uuid = UUID.fromString(pipelineId);
        ByteBuffer header = ByteBuffer.allocate(22);
        header.putInt(18);
        header.put(VERSION);
        header.put((byte)1);
        header.putLong(uuid.getMostSignificantBits());
        header.putLong(uuid.getLeastSignificantBits());
        header.rewind();
        connection.write(header);
        connection.flush();
        connection.setFlushmode(flushMode);
    }

    public void multiplex(INonBlockingConnection connection, String pipelineId, ByteBuffer[] dataToWrite) throws IOException, ClosedChannelException {
        int dataLength = 0;
        for (ByteBuffer buffer : dataToWrite) {
            dataLength += buffer.remaining();
        }
        if (LOG.isLoggable(Level.FINE)) {
            int size = 0;
            ByteBuffer[] buffers = new ByteBuffer[dataToWrite.length];
            for (int i = 0; i < buffers.length; ++i) {
                buffers[i] = dataToWrite[i].duplicate();
                size += buffers[i].remaining();
            }
            LOG.fine("[" + connection.getId() + "] sending data on pipeline " + pipelineId + ": (" + DataConverter.toFormatedBytesSize((long)size) + ") " + DataConverter.toString((ByteBuffer[])buffers, (String)"UTF-8", (int)200));
        }
        UUID uuid = UUID.fromString(pipelineId);
        ByteBuffer header = ByteBuffer.allocate(22);
        header.putInt(18 + dataLength);
        header.put(VERSION);
        header.put((byte)99);
        header.putLong(uuid.getMostSignificantBits());
        header.putLong(uuid.getLeastSignificantBits());
        header.rewind();
        connection.write(header);
        connection.write(dataToWrite);
        connection.flush();
    }

    public void demultiplex(INonBlockingConnection connection, IMultiplexer.IDemultiplexResultHandler resultHandler) throws IOException, ClosedChannelException {
        byte dataType = 0;
        String pipelineId = null;
        ByteBuffer[] data = null;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive queue size " + connection.available());
        }
        int length = ConnectionUtils.validateSufficientDatasizeByIntLengthField((INonBlockingConnection)connection);
        byte version = connection.readByte();
        if (version != VERSION) {
            throw new IOException("message with version " + version + " received. Expected is " + VERSION);
        }
        dataType = connection.readByte();
        long uuidMost = connection.readLong();
        long uuidLeast = connection.readLong();
        UUID uuid = new UUID(uuidMost, uuidLeast);
        pipelineId = uuid.toString();
        data = connection.readByteBufferByLength(length - 18);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + connection.getId() + "] got message for " + pipelineId);
        }
        switch (dataType) {
            case 99: {
                if (LOG.isLoggable(Level.FINE)) {
                    int size = 0;
                    ByteBuffer[] buffers = new ByteBuffer[data.length];
                    for (int i = 0; i < buffers.length; ++i) {
                        buffers[i] = data[i].duplicate();
                        size += buffers[i].remaining();
                    }
                    LOG.fine("[" + connection.getId() + "] received data packet on pipeline " + pipelineId + ": (" + DataConverter.toFormatedBytesSize((long)size) + ") " + DataConverter.toString((ByteBuffer[])buffers, (String)"UTF-8", (int)200));
                }
                resultHandler.onPipelineData(pipelineId, data);
                break;
            }
            case 0: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] received on pipeline " + pipelineId + " opened notification");
                }
                resultHandler.onPipelineOpend(pipelineId);
                break;
            }
            case 1: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] received on pipeline " + pipelineId + " closed notification");
                }
                resultHandler.onPipelineClosed(pipelineId);
                break;
            }
            default: {
                LOG.warning("received unknown message type " + dataType);
            }
        }
    }
}

