/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.multiplexed;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnectionScoped;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.multiplexed.INonBlockingPipeline;
import org.xsocket.connection.multiplexed.IPipelineConnectHandler;
import org.xsocket.connection.multiplexed.IPipelineConnectionTimeoutHandler;
import org.xsocket.connection.multiplexed.IPipelineDataHandler;
import org.xsocket.connection.multiplexed.IPipelineDisconnectHandler;
import org.xsocket.connection.multiplexed.IPipelineIdleTimeoutHandler;
import org.xsocket.connection.multiplexed.MultiplexedUtils;
import org.xsocket.connection.multiplexed.MultithreadedPipelineHandlerAdapter;

class PipelineHandlerAdapter
implements IConnectHandler,
IDataHandler,
IDisconnectHandler,
IIdleTimeoutHandler,
IConnectionTimeoutHandler,
ILifeCycle {
    private static final Logger LOG = Logger.getLogger(PipelineHandlerAdapter.class.getName());
    private static final IHandler NULL_HANDLER = new NullHandler();
    private static final MultiplexedUtils.HandlerInfo NULL_HANDLER_INFO = MultiplexedUtils.getHandlerInfo(NULL_HANDLER);
    private IHandler handler = null;
    private MultiplexedUtils.HandlerInfo handlerInfo = null;

    PipelineHandlerAdapter(IHandler handler, MultiplexedUtils.HandlerInfo handlerInfo) {
        this.handler = handler;
        this.handlerInfo = handlerInfo;
    }

    static PipelineHandlerAdapter newInstance(IHandler handler) {
        if (handler == null) {
            return new PipelineHandlerAdapter(NULL_HANDLER, NULL_HANDLER_INFO);
        }
        MultiplexedUtils.HandlerInfo handlerInfo = MultiplexedUtils.getHandlerInfo(handler);
        if (handlerInfo.isNonthreaded()) {
            return new PipelineHandlerAdapter(handler, handlerInfo);
        }
        return new MultithreadedPipelineHandlerAdapter(handler, handlerInfo);
    }

    final IHandler getHandler() {
        return this.handler;
    }

    final MultiplexedUtils.HandlerInfo getHandlerInfo() {
        return this.handlerInfo;
    }

    public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.handlerInfo.isConnectHandler()) {
            try {
                if (this.handlerInfo.isPipelineConnectHandler()) {
                    ((IPipelineConnectHandler)this.handler).onConnect((INonBlockingPipeline)connection);
                } else {
                    ((IConnectHandler)this.handler).onConnect(connection);
                }
            }
            catch (MaxReadSizeExceededException mee) {
                this.closeSilence(connection);
            }
            catch (BufferUnderflowException bue) {
            }
            catch (RuntimeException re) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnect by appHandler. " + this.handler + " Reason: " + re.toString());
                }
                this.closeSilence(connection);
                throw re;
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnect by appHandler. " + this.handler + " Reason: " + ioe.toString());
                }
                this.closeSilence(connection);
                throw ioe;
            }
            return false;
        }
        return false;
    }

    public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.handlerInfo.isDataHandler()) {
            while (connection.available() != 0) {
                int version = connection.getReadBufferVersion();
                try {
                    if (this.handlerInfo.isPipelineDataHandler()) {
                        ((IPipelineDataHandler)this.handler).onData((INonBlockingPipeline)connection);
                    } else {
                        ((IDataHandler)this.handler).onData(connection);
                    }
                    int newVersion = connection.getReadBufferVersion();
                    if (newVersion != version) {
                        version = newVersion;
                        continue;
                    }
                    return true;
                }
                catch (MaxReadSizeExceededException mee) {
                    this.closeSilence(connection);
                    return true;
                }
                catch (BufferUnderflowException bue) {
                    return true;
                }
                catch (RuntimeException re) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling data by appHandler. " + this.handler + " Reason: " + re.toString());
                    }
                    this.closeSilence(connection);
                    throw re;
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling data by appHandler. " + this.handler + " Reason: " + ioe.toString());
                    }
                    this.closeSilence(connection);
                    throw ioe;
                }
            }
        }
        return false;
    }

    public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
        if (this.handlerInfo.isDisconnectHandler()) {
            try {
                if (this.handlerInfo.isPipelineDisconnectHandler()) {
                    return ((IPipelineDisconnectHandler)this.handler).onDisconnect((INonBlockingPipeline)connection);
                }
                return ((IDisconnectHandler)this.handler).onDisconnect(connection);
            }
            catch (RuntimeException re) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.handler + " Reason: " + re.toString());
                }
                this.closeSilence(connection);
                throw re;
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.handler + " Reason: " + ioe.toString());
                }
                this.closeSilence(connection);
                throw ioe;
            }
        }
        return false;
    }

    public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
        if (this.handlerInfo.isIdleTimeoutHandler()) {
            try {
                boolean isHandled = false;
                isHandled = this.handlerInfo.isPipelineIdleTimeoutHandler() ? ((IPipelineIdleTimeoutHandler)this.handler).onIdleTimeout((INonBlockingPipeline)connection) : ((IIdleTimeoutHandler)this.handler).onIdleTimeout(connection);
                if (!isHandled) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + connection.getId() + "] closing connection because idle timeout has been occured and timeout handler returns true)");
                    }
                    this.closeSilence(connection);
                }
                return isHandled;
            }
            catch (MaxReadSizeExceededException mee) {
                this.closeSilence(connection);
            }
            catch (BufferUnderflowException bue) {
            }
            catch (RuntimeException re) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onIdleTimeout by appHandler. " + this.handler + " Reason: " + re.toString());
                }
                this.closeSilence(connection);
                throw re;
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onIdleTimeout by appHandler. " + this.handler + " Reason: " + ioe.toString());
                }
                this.closeSilence(connection);
                throw ioe;
            }
        } else {
            this.closeSilence(connection);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
        if (this.handlerInfo.isConnectionTimeoutHandler()) {
            try {
                boolean isHandled = false;
                isHandled = this.handlerInfo.isPipelineConnectionTimeoutHandler() ? ((IPipelineConnectionTimeoutHandler)this.handler).onConnectionTimeout((INonBlockingPipeline)connection) : ((IConnectionTimeoutHandler)this.handler).onConnectionTimeout(connection);
                if (isHandled) return true;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because connection timeout has been occured and timeout handler returns true)");
                }
                this.closeSilence(connection);
                return true;
            }
            catch (MaxReadSizeExceededException mee) {
                this.closeSilence(connection);
                return true;
            }
            catch (BufferUnderflowException bue) {
                return true;
            }
            catch (RuntimeException re) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnectionTimeout by appHandler. " + this.handler + " Reason: " + re.toString());
                }
                this.closeSilence(connection);
                throw re;
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnectionTimeout by appHandler. " + this.handler + " Reason: " + ioe.toString());
                }
                this.closeSilence(connection);
                throw ioe;
            }
        } else {
            this.closeSilence(connection);
        }
        return true;
    }

    public final void onInit() {
        if (this.handlerInfo.isLifeCycle()) {
            ((ILifeCycle)this.handler).onInit();
        }
    }

    public final void onDestroy() {
        block3: {
            if (this.handlerInfo.isLifeCycle()) {
                try {
                    ((ILifeCycle)this.handler).onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("exception occured by destroying " + this.handler + " " + ioe.toString());
                }
            }
        }
    }

    PipelineHandlerAdapter getConnectionInstance() {
        if (this.handlerInfo.isConnectionScoped()) {
            try {
                IHandler hdlCopy = (IHandler)((IConnectionScoped)this.handler).clone();
                return new PipelineHandlerAdapter(hdlCopy, this.handlerInfo);
            }
            catch (CloneNotSupportedException cnse) {
                throw new RuntimeException(cnse.toString());
            }
        }
        return this;
    }

    private void closeSilence(INonBlockingConnection connection) {
        block2: {
            try {
                connection.close();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by closing connection " + connection + " " + e.toString());
            }
        }
    }

    @Execution(value=0)
    private static final class NullHandler
    implements IHandler {
        private NullHandler() {
        }
    }
}

