/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.multiplexed;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.SerializedTaskQueue;
import org.xsocket.connection.IConnectionScoped;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.multiplexed.MultiplexedUtils;
import org.xsocket.connection.multiplexed.PipelineHandlerAdapter;

class MultithreadedPipelineHandlerAdapter
extends PipelineHandlerAdapter {
    private static final Logger LOG = Logger.getLogger(MultithreadedPipelineHandlerAdapter.class.getName());
    private final SerializedTaskQueue taskQueue = new SerializedTaskQueue();

    MultithreadedPipelineHandlerAdapter(IHandler handler, MultiplexedUtils.HandlerInfo handlerInfo) {
        super(handler, handlerInfo);
    }

    public boolean onConnect(final INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        Runnable task = new Runnable(){

            public void run() {
                block2: {
                    try {
                        MultithreadedPipelineHandlerAdapter.super.onConnect(connection);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block2;
                        LOG.fine("error occured while performing onConnect multithreaded " + MultithreadedPipelineHandlerAdapter.this.getHandler() + " " + ioe.toString());
                    }
                }
            }
        };
        if (this.getHandlerInfo().isConnectHandlerMultithreaded()) {
            this.taskQueue.performMultiThreaded(task, connection.getWorkerpool());
        } else {
            this.taskQueue.performNonThreaded(task);
        }
        return true;
    }

    public boolean onData(final INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        Runnable task = new Runnable(){

            public void run() {
                block2: {
                    try {
                        MultithreadedPipelineHandlerAdapter.super.onData(connection);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block2;
                        LOG.fine("error occured while performing onData multithreaded " + MultithreadedPipelineHandlerAdapter.this.getHandler() + " " + ioe.toString());
                    }
                }
            }
        };
        if (this.getHandlerInfo().isDataHandlerMultithreaded()) {
            this.taskQueue.performMultiThreaded(task, connection.getWorkerpool());
        } else {
            this.taskQueue.performNonThreaded(task);
        }
        return true;
    }

    public boolean onDisconnect(final INonBlockingConnection connection) throws IOException {
        Runnable task = new Runnable(){

            public void run() {
                block2: {
                    try {
                        MultithreadedPipelineHandlerAdapter.super.onDisconnect(connection);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block2;
                        LOG.fine("error occured while performing onDisconnect multithreaded " + MultithreadedPipelineHandlerAdapter.this.getHandler() + " " + ioe.toString());
                    }
                }
            }
        };
        if (this.getHandlerInfo().isDisconnectHandlerMultithreaded()) {
            this.taskQueue.performMultiThreaded(task, connection.getWorkerpool());
        } else {
            this.taskQueue.performNonThreaded(task);
        }
        return true;
    }

    public boolean onIdleTimeout(final INonBlockingConnection connection) throws IOException {
        Runnable task = new Runnable(){

            public void run() {
                block2: {
                    try {
                        MultithreadedPipelineHandlerAdapter.super.onIdleTimeout(connection);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block2;
                        LOG.fine("error occured while performing onIdleTimeout multithreaded " + MultithreadedPipelineHandlerAdapter.this.getHandler() + " " + ioe.toString());
                    }
                }
            }
        };
        if (this.getHandlerInfo().isIdleTimeoutHandlerMultithreaded()) {
            this.taskQueue.performMultiThreaded(task, connection.getWorkerpool());
        } else {
            this.taskQueue.performNonThreaded(task);
        }
        return true;
    }

    public boolean onConnectionTimeout(final INonBlockingConnection connection) throws IOException {
        Runnable task = new Runnable(){

            public void run() {
                block2: {
                    try {
                        MultithreadedPipelineHandlerAdapter.super.onConnectionTimeout(connection);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block2;
                        LOG.fine("error occured while performing onConnectionTimeout multithreaded " + MultithreadedPipelineHandlerAdapter.this.getHandler() + " " + ioe.toString());
                    }
                }
            }
        };
        if (this.getHandlerInfo().isConnectionTimeoutHandlerMultithreaded()) {
            this.taskQueue.performMultiThreaded(task, connection.getWorkerpool());
        } else {
            this.taskQueue.performNonThreaded(task);
        }
        return true;
    }

    PipelineHandlerAdapter getConnectionInstance() {
        if (this.getHandlerInfo().isConnectionScoped()) {
            try {
                IHandler hdlCopy = (IHandler)((IConnectionScoped)this.getHandler()).clone();
                return new MultithreadedPipelineHandlerAdapter(hdlCopy, this.getHandlerInfo());
            }
            catch (CloneNotSupportedException cnse) {
                throw new RuntimeException(cnse.toString());
            }
        }
        return new MultithreadedPipelineHandlerAdapter(this.getHandler(), this.getHandlerInfo());
    }
}

