/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.multiplexed;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Logger;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.Resource;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnectionScoped;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IServer;
import org.xsocket.connection.multiplexed.INonBlockingPipeline;
import org.xsocket.connection.multiplexed.IPipelineConnectHandler;
import org.xsocket.connection.multiplexed.IPipelineConnectionTimeoutHandler;
import org.xsocket.connection.multiplexed.IPipelineDataHandler;
import org.xsocket.connection.multiplexed.IPipelineDisconnectHandler;
import org.xsocket.connection.multiplexed.IPipelineIdleTimeoutHandler;

final class MultiplexedUtils {
    private static final Logger LOG = Logger.getLogger(MultiplexedUtils.class.getName());
    private static final Map<Class, HandlerInfo> handlerInfoCache = ConnectionUtils.newMapCache((int)25);
    private static String versionInfo = null;

    private MultiplexedUtils() {
    }

    public static String getVersionInfo() {
        if (versionInfo == null) {
            versionInfo = "<unknown>";
            try {
                InputStreamReader isr = new InputStreamReader(MultiplexedUtils.class.getResourceAsStream("/org/xsocket/connection/multiplexed/version.txt"));
                if (isr != null) {
                    LineNumberReader lnr = new LineNumberReader(isr);
                    String line = null;
                    do {
                        if ((line = lnr.readLine()) == null || !line.startsWith("Implementation-Version=")) continue;
                        versionInfo = line.substring("Implementation-Version=".length(), line.length()).trim();
                    } while (line != null);
                    lnr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return versionInfo;
    }

    static void injectServerField(IServer server, Object handler) {
        Field[] fields;
        for (Field field : fields = handler.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Resource.class)) continue;
            Resource res = field.getAnnotation(Resource.class);
            if (field.getType() != IServer.class && res.type() != IServer.class) continue;
            field.setAccessible(true);
            try {
                field.set(handler, server);
            }
            catch (IllegalAccessException iae) {
                LOG.warning("could not inject server for attribute " + field.getName() + ". Reason " + iae.toString());
            }
        }
    }

    static HandlerInfo getHandlerInfo(IHandler handler) {
        HandlerInfo handlerInfo = handlerInfoCache.get(handler.getClass());
        if (handlerInfo == null) {
            handlerInfo = new HandlerInfo(handler);
            handlerInfoCache.put(handler.getClass(), handlerInfo);
        }
        return handlerInfo;
    }

    private static boolean isHandlerMultithreaded(IHandler handler) {
        Execution execution = handler.getClass().getAnnotation(Execution.class);
        if (execution != null) {
            return execution.value() != 0;
        }
        return true;
    }

    private static boolean isThreaded(Class clazz, String methodname, boolean dflt, Class ... paramClass) {
        try {
            Method meth = clazz.getMethod(methodname, paramClass);
            Execution execution = meth.getAnnotation(Execution.class);
            if (execution != null) {
                return execution.value() != 0;
            }
            return dflt;
        }
        catch (NoSuchMethodException nsme) {
            return dflt;
        }
    }

    static final class HandlerInfo {
        private boolean isConnectHandler = false;
        private boolean isPipelineConnectHandler = false;
        private boolean isConnectHandlerMultithreaded = false;
        private boolean isDataHandler = false;
        private boolean isPipelineDataHandler = false;
        private boolean isDataHandlerMultithreaded = false;
        private boolean isDisconnectHandler = false;
        private boolean isPipelineDisconnectHandler = false;
        private boolean isDisconnectHandlerMultithreaded = false;
        private boolean isIdleTimeoutHandler = false;
        private boolean isPipelineIdleTimeoutHandler = false;
        private boolean isIdleTimeoutHandlerMultithreaded = false;
        private boolean isConnectionTimeoutHandler = false;
        private boolean isPipelineConnectionTimeoutHandler = false;
        private boolean isConnectionTimeoutHandlerMultithreaded = false;
        private boolean isLifeCycle = false;
        private boolean isConnectionScoped = false;
        private boolean isHandlerMultithreaded = false;
        private boolean isNonThreaded = false;

        HandlerInfo(IHandler handler) {
            this.isConnectHandler = handler instanceof IConnectHandler;
            this.isDataHandler = handler instanceof IDataHandler;
            this.isDisconnectHandler = handler instanceof IDisconnectHandler;
            this.isIdleTimeoutHandler = handler instanceof IIdleTimeoutHandler;
            this.isConnectionTimeoutHandler = handler instanceof IConnectionTimeoutHandler;
            this.isLifeCycle = handler instanceof ILifeCycle;
            this.isConnectionScoped = handler instanceof IConnectionScoped;
            this.isHandlerMultithreaded = MultiplexedUtils.isHandlerMultithreaded(handler);
            if (this.isHandlerMultithreaded()) {
                this.isConnectHandlerMultithreaded = true;
                this.isDisconnectHandlerMultithreaded = true;
                this.isDataHandlerMultithreaded = true;
                this.isConnectionTimeoutHandlerMultithreaded = true;
                this.isIdleTimeoutHandlerMultithreaded = true;
            }
            if (handler instanceof IConnectHandler) {
                this.isConnectHandler = true;
                this.isConnectHandlerMultithreaded = MultiplexedUtils.isThreaded(handler.getClass(), "onConnect", this.isHandlerMultithreaded(), new Class[]{INonBlockingConnection.class});
            }
            if (handler instanceof IDataHandler) {
                this.isDataHandler = true;
                this.isDataHandlerMultithreaded = MultiplexedUtils.isThreaded(handler.getClass(), "onData", this.isHandlerMultithreaded(), new Class[]{INonBlockingConnection.class});
            }
            if (handler instanceof IDisconnectHandler) {
                this.isDisconnectHandler = true;
                this.isDisconnectHandlerMultithreaded = MultiplexedUtils.isThreaded(handler.getClass(), "onDisconnect", this.isHandlerMultithreaded(), new Class[]{INonBlockingConnection.class});
            }
            if (handler instanceof IIdleTimeoutHandler) {
                this.isIdleTimeoutHandler = true;
                this.isIdleTimeoutHandlerMultithreaded = MultiplexedUtils.isThreaded(handler.getClass(), "onIdleTimeout", this.isHandlerMultithreaded(), new Class[]{INonBlockingConnection.class});
            }
            if (handler instanceof IConnectionTimeoutHandler) {
                this.isConnectionTimeoutHandler = true;
                this.isConnectionTimeoutHandlerMultithreaded = MultiplexedUtils.isThreaded(handler.getClass(), "onConnectionTimeout", this.isHandlerMultithreaded(), new Class[]{INonBlockingConnection.class});
            }
            if (handler instanceof IPipelineConnectHandler) {
                this.isPipelineConnectHandler = true;
                this.isConnectHandler = true;
                this.isConnectHandlerMultithreaded = MultiplexedUtils.isThreaded(handler.getClass(), "onConnect", this.isHandlerMultithreaded(), new Class[]{INonBlockingPipeline.class});
            }
            if (handler instanceof IPipelineDisconnectHandler) {
                this.isPipelineDisconnectHandler = true;
                this.isDisconnectHandler = true;
                this.isDisconnectHandlerMultithreaded = MultiplexedUtils.isThreaded(handler.getClass(), "onDisconnect", this.isHandlerMultithreaded(), new Class[]{INonBlockingPipeline.class});
            }
            if (handler instanceof IPipelineDataHandler) {
                this.isPipelineDataHandler = true;
                this.isDataHandler = true;
                this.isDataHandlerMultithreaded = MultiplexedUtils.isThreaded(handler.getClass(), "onData", this.isHandlerMultithreaded(), new Class[]{INonBlockingPipeline.class});
            }
            if (handler instanceof IPipelineIdleTimeoutHandler) {
                this.isPipelineIdleTimeoutHandler = true;
                this.isIdleTimeoutHandler = true;
                this.isIdleTimeoutHandlerMultithreaded = MultiplexedUtils.isThreaded(handler.getClass(), "onIdleTimeout", this.isHandlerMultithreaded(), new Class[]{INonBlockingPipeline.class});
            }
            if (handler instanceof IPipelineConnectionTimeoutHandler) {
                this.isPipelineConnectionTimeoutHandler = true;
                this.isConnectionTimeoutHandler = true;
                this.isConnectionTimeoutHandlerMultithreaded = MultiplexedUtils.isThreaded(handler.getClass(), "onConnectionTimeout", this.isHandlerMultithreaded(), new Class[]{INonBlockingPipeline.class});
            }
            this.isConnectionScoped = handler instanceof IConnectionScoped;
            this.isLifeCycle = handler instanceof ILifeCycle;
            this.isNonThreaded = !this.isHandlerMultithreaded && !this.isConnectHandlerMultithreaded && !this.isDataHandlerMultithreaded && !this.isDisconnectHandlerMultithreaded && !this.isIdleTimeoutHandlerMultithreaded && !this.isConnectionTimeoutHandlerMultithreaded;
        }

        public boolean isPipelineConnectHandler() {
            return this.isPipelineConnectHandler;
        }

        public boolean isConnectHandler() {
            return this.isConnectHandler;
        }

        public boolean isDataHandler() {
            return this.isDataHandler;
        }

        public boolean isPipelineDataHandler() {
            return this.isPipelineDataHandler;
        }

        public boolean isDisconnectHandler() {
            return this.isDisconnectHandler;
        }

        public boolean isPipelineDisconnectHandler() {
            return this.isPipelineDisconnectHandler;
        }

        public boolean isIdleTimeoutHandler() {
            return this.isIdleTimeoutHandler;
        }

        public boolean isPipelineIdleTimeoutHandler() {
            return this.isPipelineIdleTimeoutHandler;
        }

        public boolean isConnectionTimeoutHandler() {
            return this.isConnectionTimeoutHandler;
        }

        public boolean isPipelineConnectionTimeoutHandler() {
            return this.isPipelineConnectionTimeoutHandler;
        }

        public boolean isLifeCycle() {
            return this.isLifeCycle;
        }

        public boolean isConnectionScoped() {
            return this.isConnectionScoped;
        }

        public boolean isNonthreaded() {
            return this.isNonThreaded;
        }

        public boolean isHandlerMultithreaded() {
            return this.isHandlerMultithreaded;
        }

        public boolean isConnectHandlerMultithreaded() {
            return this.isConnectHandlerMultithreaded;
        }

        public boolean isDataHandlerMultithreaded() {
            return this.isDataHandlerMultithreaded;
        }

        public boolean isDisconnectHandlerMultithreaded() {
            return this.isDisconnectHandlerMultithreaded;
        }

        public boolean isIdleTimeoutHandlerMultithreaded() {
            return this.isIdleTimeoutHandlerMultithreaded;
        }

        public boolean isConnectionTimeoutHandlerMultithreaded() {
            return this.isConnectionTimeoutHandlerMultithreaded;
        }
    }
}

