/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.multiplexed;

import java.io.IOException;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.Resource;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IServer;
import org.xsocket.connection.multiplexed.MultiplexedConnection;
import org.xsocket.connection.multiplexed.MultiplexedUtils;
import org.xsocket.connection.multiplexed.PipelineHandlerAdapter;
import org.xsocket.connection.multiplexed.multiplexer.DefaultMultiplexer;
import org.xsocket.connection.multiplexed.multiplexer.IMultiplexer;

@Execution(value=0)
public final class MultiplexedProtocolAdapter
implements IConnectHandler,
ILifeCycle {
    @Resource
    private IServer server = null;
    private IHandler handler = null;
    private PipelineHandlerAdapter handlerAdapter = null;
    private IMultiplexer multiplexer = null;

    public MultiplexedProtocolAdapter(IHandler handler) {
        this(handler, new DefaultMultiplexer());
    }

    public MultiplexedProtocolAdapter(IHandler handler, IMultiplexer multiplexer) {
        this.handler = handler;
        this.multiplexer = multiplexer;
    }

    public void onInit() {
        this.server.setStartUpLogMessage(this.server.getStartUpLogMessage() + "; multiplexed " + MultiplexedUtils.getVersionInfo());
        this.handlerAdapter = PipelineHandlerAdapter.newInstance(this.handler);
        MultiplexedUtils.injectServerField(this.server, this.handlerAdapter.getHandler());
        this.handlerAdapter.onInit();
    }

    public void onDestroy() {
        this.handlerAdapter.onDestroy();
    }

    public boolean onConnect(INonBlockingConnection connection) throws IOException {
        new MultiplexedConnection(connection, this.handlerAdapter, this.multiplexer);
        return true;
    }
}

