/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection.multiplexed;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.Execution;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.AbstractNonBlockingStream;
import org.xsocket.connection.BlockingConnection;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.multiplexed.IBlockingPipeline;
import org.xsocket.connection.multiplexed.IMultiplexedConnection;
import org.xsocket.connection.multiplexed.INonBlockingPipeline;
import org.xsocket.connection.multiplexed.PipelineHandlerAdapter;
import org.xsocket.connection.multiplexed.multiplexer.DefaultMultiplexer;
import org.xsocket.connection.multiplexed.multiplexer.IMultiplexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiplexedConnection
implements IMultiplexedConnection {
    private static final Logger LOG = Logger.getLogger(MultiplexedConnection.class.getName());
    private static final Timer TIMER = new Timer("xPipelineTimer", true);
    private static final long MIN_WATCHDOG_PERIOD_MILLIS = 30000L;
    private final HashMap<String, NonBlockingPipeline> pipelines = new HashMap();
    private INonBlockingConnection connection = null;
    private IMultiplexer multiplexer = null;
    private final Object multiplexerWriteGuard = new Object();
    private final Object multiplexerReadGuard = new Object();
    private final DemultiplexResultHandler demultiplexResultHandler = new DemultiplexResultHandler();
    private PipelineHandlerAdapter handlerAdapter = PipelineHandlerAdapter.newInstance(null);

    public MultiplexedConnection(INonBlockingConnection connection) throws IOException {
        this(connection, new DefaultMultiplexer());
    }

    public MultiplexedConnection(INonBlockingConnection connection, IMultiplexer multiplexer) throws IOException {
        this(connection, PipelineHandlerAdapter.newInstance(null), multiplexer);
    }

    public MultiplexedConnection(INonBlockingConnection connection, IHandler pipelineHandler, IMultiplexer multiplexer) throws IOException {
        this(connection, PipelineHandlerAdapter.newInstance(pipelineHandler), multiplexer);
    }

    public MultiplexedConnection(INonBlockingConnection connection, IHandler pipelineHandler) throws IOException {
        this(connection, PipelineHandlerAdapter.newInstance(pipelineHandler), (IMultiplexer)new DefaultMultiplexer());
    }

    MultiplexedConnection(INonBlockingConnection connection, PipelineHandlerAdapter handlerAdapter, IMultiplexer multiplexer) throws IOException {
        this.connection = connection;
        this.multiplexer = multiplexer;
        this.handlerAdapter = handlerAdapter;
        connection.setAutoflush(false);
        connection.setFlushmode(IConnection.FlushMode.SYNC);
        connection.setHandler((IHandler)new MultiplexedConnectionHandler(this));
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block6: {
            HashMap copy = null;
            HashMap<String, NonBlockingPipeline> hashMap = this.pipelines;
            synchronized (hashMap) {
                copy = (HashMap)this.pipelines.clone();
            }
            for (NonBlockingPipeline pipeline : copy.values()) {
                pipeline.closeSilence();
            }
            try {
                this.connection.close();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block6;
                LOG.fine("[" + this.getId() + "] error occured by closing connection " + e.toString());
            }
        }
    }

    @Override
    public String getId() {
        return this.connection.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateSecuredMode() throws IOException {
        HashMap<String, NonBlockingPipeline> hashMap = this.pipelines;
        synchronized (hashMap) {
            for (NonBlockingPipeline pipline : this.pipelines.values()) {
                pipline.flush();
            }
        }
        this.connection.activateSecuredMode();
    }

    public boolean isSecure() {
        return this.connection.isSecure();
    }

    @Override
    public String getDefaultEncoding() {
        return this.connection.getEncoding();
    }

    @Override
    public void setDefaultEncoding(String encoding) {
        this.connection.setEncoding(encoding);
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.connection.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.connection.getRemotePort();
    }

    @Override
    public Object getOption(String name) throws IOException {
        return this.connection.getOption(name);
    }

    @Override
    public Map<String, Class> getOptions() {
        return this.connection.getOptions();
    }

    @Override
    public void setOption(String name, Object value) throws IOException {
        this.connection.setOption(name, value);
    }

    public void setConnectionTimeoutMillis(long timeoutMillis) {
        this.connection.setConnectionTimeoutMillis(timeoutMillis);
    }

    public long getConnectionTimeoutMillis() {
        return this.connection.getConnectionTimeoutMillis();
    }

    public void setIdleTimeoutMillis(long timeoutMillis) {
        this.connection.setIdleTimeoutMillis(timeoutMillis);
    }

    public long getIdleTimeoutMillis() {
        return this.connection.getIdleTimeoutMillis();
    }

    public long getRemainingMillisToConnectionTimeout() {
        return this.connection.getRemainingMillisToConnectionTimeout();
    }

    public long getRemainingMillisToIdleTimeout() {
        return this.connection.getRemainingMillisToIdleTimeout();
    }

    public void setAttachment(Object obj) {
        this.connection.setAttachment(obj);
    }

    public Object getAttachment() {
        return this.connection.getAttachment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createPipeline() throws IOException {
        String pipelineId = this.registerNewPipeline();
        NonBlockingPipeline pipeline = new NonBlockingPipeline(pipelineId, this.handlerAdapter);
        HashMap<String, NonBlockingPipeline> hashMap = this.pipelines;
        synchronized (hashMap) {
            this.pipelines.put(pipelineId, pipeline);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] pipeline " + pipelineId + " created");
        }
        return pipelineId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listOpenPipelines() throws ClosedChannelException {
        String[] result = null;
        HashMap<String, NonBlockingPipeline> hashMap = this.pipelines;
        synchronized (hashMap) {
            Set<String> ids = this.pipelines.keySet();
            result = ids.toArray(new String[ids.size()]);
        }
        return result;
    }

    private void closePipeline(NonBlockingPipeline pipeline) throws IOException {
        if (pipeline == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("warning try to close a <null> pipeline");
            }
            return;
        }
        this.deregisterPipeline(pipeline.getId());
        this.removePipeline(pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePipeline(NonBlockingPipeline pipeline) {
        NonBlockingPipeline pipe = null;
        HashMap<String, NonBlockingPipeline> hashMap = this.pipelines;
        synchronized (hashMap) {
            pipe = this.pipelines.remove(pipeline.getId());
        }
        if (pipe != null) {
            pipeline.onClose();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] pipeline " + pipeline.getId() + " destroyed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INonBlockingPipeline getNonBlockingPipeline(String pipelineId) throws ClosedChannelException {
        if (this.connection.isOpen()) {
            HashMap<String, NonBlockingPipeline> hashMap = this.pipelines;
            synchronized (hashMap) {
                return this.pipelines.get(pipelineId);
            }
        }
        throw new ClosedChannelException();
    }

    @Override
    public IBlockingPipeline getBlockingPipeline(String pipelineId) throws ClosedChannelException, IOException {
        return new BlockingPipeline(this.getNonBlockingPipeline(pipelineId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onData() throws IOException {
        Object object = this.multiplexerReadGuard;
        synchronized (object) {
            this.multiplexer.demultiplex(this.connection, this.demultiplexResultHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPipelineOpened(String pipelineId) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] pipeline " + pipelineId + " opened by peer");
        }
        NonBlockingPipeline pipeline = new NonBlockingPipeline(pipelineId, this.handlerAdapter);
        HashMap<String, NonBlockingPipeline> hashMap = this.pipelines;
        synchronized (hashMap) {
            this.pipelines.put(pipelineId, pipeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPipelineClosed(String pipelineId) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] pipeline " + pipelineId + " closed by peer");
        }
        NonBlockingPipeline pipeline = null;
        HashMap<String, NonBlockingPipeline> hashMap = this.pipelines;
        synchronized (hashMap) {
            pipeline = this.pipelines.get(pipelineId);
        }
        if (pipeline != null) {
            this.removePipeline(pipeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPipelineData(String pipelineId, ByteBuffer[] data) {
        NonBlockingPipeline pipeline = null;
        HashMap<String, NonBlockingPipeline> hashMap = this.pipelines;
        synchronized (hashMap) {
            pipeline = this.pipelines.get(pipelineId);
        }
        if (pipeline != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("notifying pipeline data handler");
            }
            pipeline.onData(data);
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("data received for non existing pipeline " + pipelineId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String registerNewPipeline() throws ClosedChannelException, IOException {
        Object object = this.multiplexerWriteGuard;
        synchronized (object) {
            return this.multiplexer.openPipeline(this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterPipeline(String pipelineId) throws ClosedChannelException, IOException {
        Object object = this.multiplexerWriteGuard;
        synchronized (object) {
            this.multiplexer.closePipeline(this.connection, pipelineId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPipelineData(String pipelineId, ByteBuffer[] dataToWrite, IConnection.FlushMode flushMode) throws ClosedChannelException, IOException {
        if (dataToWrite == null) {
            return;
        }
        if (dataToWrite.length == 0) {
            return;
        }
        Object object = this.multiplexerWriteGuard;
        synchronized (object) {
            this.connection.setFlushmode(flushMode);
            this.multiplexer.multiplex(this.connection, pipelineId, dataToWrite);
            this.connection.setFlushmode(IConnection.FlushMode.SYNC);
        }
    }

    private static final class WatchDogTask
    extends TimerTask {
        private WeakReference<NonBlockingPipeline> nonBlockingPipelineRef = null;

        public WatchDogTask(NonBlockingPipeline nonBlockingPipeline) {
            this.nonBlockingPipelineRef = new WeakReference<NonBlockingPipeline>(nonBlockingPipeline);
        }

        public void run() {
            NonBlockingPipeline nonBlockingPipeline = (NonBlockingPipeline)this.nonBlockingPipelineRef.get();
            if (nonBlockingPipeline == null) {
                this.cancel();
            } else {
                nonBlockingPipeline.checkTimeouts();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NonBlockingPipeline
    extends AbstractNonBlockingStream
    implements INonBlockingPipeline {
        private String pipelineId = null;
        private boolean isOpen = true;
        private boolean isSuspendRead = false;
        private final ArrayList<ByteBuffer> suspendBuffer = new ArrayList();
        private long connectionTimeoutMillis = Long.MAX_VALUE;
        private long idleTimeoutMillis = Long.MAX_VALUE;
        private long idleTimeoutDateMillis = Long.MAX_VALUE;
        private long connectionTimeoutDateMillis = Long.MAX_VALUE;
        private long lastReceivedMillis = System.currentTimeMillis();
        private boolean idleTimeoutOccured = false;
        private boolean connectionTimeoutOccured = false;
        private WatchDogTask watchDogTask = null;
        private IHandler handler = null;

        NonBlockingPipeline(String pipelineId, PipelineHandlerAdapter handlerAdapter) {
            this.pipelineId = pipelineId;
            this.handler = handlerAdapter.getConnectionInstance();
            this.onOpen();
        }

        private void onOpen() {
            block2: {
                try {
                    ((IConnectHandler)this.handler).onConnect((INonBlockingConnection)this);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by performing onConnect call back on " + this.handler + " " + ioe.toString());
                }
            }
        }

        protected boolean isDataWriteable() {
            try {
                return MultiplexedConnection.this.getNonBlockingPipeline(this.pipelineId) != null;
            }
            catch (ClosedChannelException ce) {
                return false;
            }
        }

        protected boolean isMoreInputDataExpected() {
            try {
                return MultiplexedConnection.this.getNonBlockingPipeline(this.pipelineId) != null;
            }
            catch (ClosedChannelException ce) {
                return false;
            }
        }

        public boolean isOpen() {
            if (!this.isOpen) {
                return false;
            }
            if (!this.isReadBufferEmpty()) {
                return true;
            }
            try {
                return MultiplexedConnection.this.getNonBlockingPipeline(this.pipelineId) != null;
            }
            catch (ClosedChannelException ce) {
                return false;
            }
        }

        public void close() throws IOException {
            super.close();
            if (this.isOpen) {
                MultiplexedConnection.this.closePipeline(this);
            }
            this.isOpen = false;
        }

        private void onClose() {
            block2: {
                this.terminateWatchDog();
                try {
                    ((IDisconnectHandler)this.handler).onDisconnect((INonBlockingConnection)this);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by performing onDisconnect call back on " + this.handler + " " + ioe.toString());
                }
            }
        }

        public void onData(ByteBuffer[] data) {
            block5: {
                if (this.isSuspendRead) {
                    for (ByteBuffer byteBuffer : data) {
                        this.suspendBuffer.add(byteBuffer);
                    }
                    return;
                }
                this.appendDataToReadBuffer(data);
                try {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("notifying handler " + this.handler);
                    }
                    ((IDataHandler)this.handler).onData((INonBlockingConnection)this);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("error occured by calling onData for pipeline " + this.getId() + " " + ioe.toString());
                }
            }
        }

        private void onConnectionTimeout() {
            if (!this.connectionTimeoutOccured) {
                this.connectionTimeoutOccured = true;
                try {
                    ((IConnectionTimeoutHandler)this.handler).onConnectionTimeout((INonBlockingConnection)this);
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("error occured by performing onConnectionTimeout call back on " + this.handler + " " + ioe.toString());
                    }
                }
            } else {
                this.setConnectionTimeoutMillis(Long.MAX_VALUE);
            }
        }

        private void onIdleTimeout() {
            if (!this.idleTimeoutOccured) {
                this.idleTimeoutOccured = true;
                try {
                    ((IIdleTimeoutHandler)this.handler).onIdleTimeout((INonBlockingConnection)this);
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("error occured by performing onIdleTimeout call back on " + this.handler + " " + ioe.toString());
                    }
                }
            } else {
                this.setIdleTimeoutMillis(Long.MAX_VALUE);
            }
        }

        void closeSilence() {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getId() {
            return this.pipelineId;
        }

        public Executor getWorkerpool() {
            return MultiplexedConnection.this.connection.getWorkerpool();
        }

        @Override
        public IMultiplexedConnection getMultiplexedConnection() {
            return MultiplexedConnection.this;
        }

        public void setMaxReadBufferThreshold(int size) {
            throw new UnsupportedOperationException("setMaxReadBufferThreshold is not supported for a pipeline. perform this operation on the MultiplexedConnection");
        }

        public int getMaxReadBufferThreshold() {
            return MultiplexedConnection.this.connection.getMaxReadBufferThreshold();
        }

        public long getConnectionTimeoutMillis() {
            return this.connectionTimeoutMillis;
        }

        public void setConnectionTimeoutMillis(long timeoutMillis) {
            this.connectionTimeoutDateMillis = System.currentTimeMillis() + timeoutMillis;
            if (this.connectionTimeoutMillis != timeoutMillis) {
                this.connectionTimeoutMillis = timeoutMillis;
                this.updateWatchdog(this.connectionTimeoutMillis, this.idleTimeoutMillis);
            }
            this.connectionTimeoutOccured = false;
        }

        public long getIdleTimeoutMillis() {
            return this.idleTimeoutMillis;
        }

        public void setIdleTimeoutMillis(long timeoutMillis) {
            this.idleTimeoutDateMillis = System.currentTimeMillis() + timeoutMillis;
            if (this.idleTimeoutMillis != timeoutMillis) {
                this.idleTimeoutMillis = timeoutMillis;
                this.updateWatchdog(this.connectionTimeoutMillis, this.idleTimeoutMillis);
            }
            this.idleTimeoutOccured = false;
        }

        private synchronized void updateWatchdog(long connectionTimeoutMillis, long idleTimeoutMillis) {
            long watchdogPeriod = connectionTimeoutMillis;
            if (idleTimeoutMillis < watchdogPeriod) {
                watchdogPeriod = idleTimeoutMillis;
            }
            if (watchdogPeriod > 500L) {
                watchdogPeriod /= 5L;
            }
            if (watchdogPeriod > 30000L) {
                watchdogPeriod = 30000L;
            }
            this.terminateWatchDog();
            this.watchDogTask = new WatchDogTask(this);
            TIMER.schedule((TimerTask)this.watchDogTask, watchdogPeriod, watchdogPeriod);
        }

        private synchronized void terminateWatchDog() {
            if (this.watchDogTask != null) {
                this.watchDogTask.cancel();
            }
        }

        private void checkTimeouts() {
            long currentMillis = System.currentTimeMillis();
            if (this.getRemainingMillisToConnectionTimeout(currentMillis) <= 0L) {
                this.onConnectionTimeout();
            }
            if (this.getRemainingMillisToIdleTimeout(currentMillis) <= 0L) {
                this.onIdleTimeout();
            }
        }

        public long getRemainingMillisToConnectionTimeout() {
            return this.getRemainingMillisToConnectionTimeout(System.currentTimeMillis());
        }

        private long getRemainingMillisToConnectionTimeout(long currentMillis) {
            return this.connectionTimeoutDateMillis - currentMillis;
        }

        public long getRemainingMillisToIdleTimeout() {
            return this.getRemainingMillisToIdleTimeout(System.currentTimeMillis());
        }

        private long getRemainingMillisToIdleTimeout(long currentMillis) {
            long remaining = this.idleTimeoutDateMillis - currentMillis;
            if (remaining > 0L) {
                return remaining;
            }
            return this.lastReceivedMillis + this.idleTimeoutMillis - currentMillis;
        }

        @Override
        public void setWriteTransferRate(int bytesPerSecond) throws ClosedChannelException, IOException {
            throw new UnsupportedOperationException("setWriteTransferRate is not supported for a pipeline. perform this operation on the MultiplexedConnection");
        }

        public void setHandler(IHandler hdl) throws IOException {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] set handler " + hdl);
            }
            this.handler = PipelineHandlerAdapter.newInstance(hdl);
            if (this.available() > 0) {
                this.onData(null);
            }
        }

        public void setOption(String name, Object value) throws IOException {
            LOG.warning("set option is vaild for all pipelines. Better use <MultiplexedcCnnection>.serOptions(String, Object)");
            MultiplexedConnection.this.connection.setOption(name, value);
        }

        public Object getOption(String name) throws IOException {
            return MultiplexedConnection.this.connection.getOption(name);
        }

        public Map<String, Class> getOptions() {
            return MultiplexedConnection.this.connection.getOptions();
        }

        public InetAddress getLocalAddress() {
            return MultiplexedConnection.this.connection.getLocalAddress();
        }

        public int getLocalPort() {
            return MultiplexedConnection.this.connection.getLocalPort();
        }

        public InetAddress getRemoteAddress() {
            return MultiplexedConnection.this.connection.getRemoteAddress();
        }

        public int getRemotePort() {
            return MultiplexedConnection.this.connection.getRemotePort();
        }

        public void suspendRead() throws IOException {
            this.isSuspendRead = true;
        }

        public void resumeRead() throws IOException {
            this.isSuspendRead = false;
            ArrayList data = (ArrayList)this.suspendBuffer.clone();
            this.suspendBuffer.clear();
            this.onData(data.toArray(new ByteBuffer[data.size()]));
        }

        public int getPendingWriteDataSize() {
            return this.getWriteBufferSize();
        }

        @Override
        public void activateSecuredMode() throws IOException {
            throw new UnsupportedOperationException("activateSecuredMode is not supported for a pipeline. perform this operation on the MultiplexedConnection");
        }

        public boolean isSecure() {
            return MultiplexedConnection.this.connection.isSecure();
        }

        public long transferFrom(ReadableByteChannel sourceChannel) throws ClosedChannelException, IOException, SocketTimeoutException {
            int chunkSize = (Integer)this.getOption("SOL_SOCKET.SO_SNDBUF");
            long transfered = 0L;
            int read = 0;
            do {
                ByteBuffer transferBuffer;
                if ((read = sourceChannel.read(transferBuffer = ByteBuffer.allocate(chunkSize))) <= 0) continue;
                if (transferBuffer.remaining() == 0) {
                    transferBuffer.flip();
                    this.write(transferBuffer);
                } else {
                    transferBuffer.flip();
                    this.write(transferBuffer.slice());
                }
                transfered += (long)read;
            } while (read > 0);
            return transfered;
        }

        protected void onWriteDataInserted() throws IOException, ClosedChannelException {
            if (this.isAutoflush()) {
                this.flush();
            }
        }

        public void flush() throws ClosedChannelException, IOException {
            this.removeWriteMark();
            ByteBuffer[] dataToWrite = this.drainWriteQueue();
            MultiplexedConnection.this.sendPipelineData(this.getId(), dataToWrite, this.getFlushmode());
        }

        public String toString() {
            try {
                if (this.isOpen()) {
                    return "id=" + this.getId() + ", remote=" + this.getRemoteAddress().getCanonicalHostName() + "(" + this.getRemoteAddress() + ":" + this.getRemotePort() + ")";
                }
                return "id=" + this.getId() + " (closed)";
            }
            catch (Exception e) {
                return super.toString();
            }
        }
    }

    @Execution(value=0)
    private static final class MultiplexedConnectionHandler
    implements IConnectHandler,
    IDataHandler,
    IDisconnectHandler,
    IIdleTimeoutHandler,
    IConnectionTimeoutHandler {
        private MultiplexedConnection multiplexedConnection = null;

        private MultiplexedConnectionHandler(MultiplexedConnection multiplexedConnection) {
            this.multiplexedConnection = multiplexedConnection;
        }

        public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            if (connection.available() > 0) {
                this.onData(connection);
            }
            return true;
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            this.multiplexedConnection.onData();
            return true;
        }

        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            this.multiplexedConnection.close();
            return true;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            this.multiplexedConnection.close();
            return true;
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            this.multiplexedConnection.close();
            return true;
        }
    }

    private final class DemultiplexResultHandler
    implements IMultiplexer.IDemultiplexResultHandler {
        private DemultiplexResultHandler() {
        }

        public void onPipelineOpend(String pipelineId) {
            MultiplexedConnection.this.onPipelineOpened(pipelineId);
        }

        public void onPipelineClosed(String pipelineId) {
            MultiplexedConnection.this.onPipelineClosed(pipelineId);
        }

        public void onPipelineData(String pipelineId, ByteBuffer[] data) {
            MultiplexedConnection.this.onPipelineData(pipelineId, data);
        }
    }

    private static final class BlockingPipeline
    extends BlockingConnection
    implements IBlockingPipeline {
        private INonBlockingPipeline delegee = null;

        BlockingPipeline(INonBlockingPipeline delegee) throws IOException {
            super((INonBlockingConnection)delegee);
            this.delegee = delegee;
        }

        public IMultiplexedConnection getMultiplexedConnection() {
            return this.delegee.getMultiplexedConnection();
        }
    }
}

