/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.storage;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.xerial.db.DBErrorCode;
import org.xerial.db.DBException;
import org.xerial.db.storage.DBFile;

public class MemoryFile
implements DBFile {
    private final int chunkSize = 1024;
    private ArrayList<MemoryChunk> chunkList = new ArrayList();
    private long fileCursor = 0L;

    public void loadFromFile(String string) throws IOException, DBException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        byte[] byArray = new byte[1];
        while ((n = bufferedReader.read()) != -1) {
            byArray[0] = (byte)n;
            this.write(byArray, 0, 1);
        }
    }

    private int chunkIndex(long l) {
        return (int)(l / 1024L);
    }

    private int chunkOffset(long l) {
        return (int)(l % 1024L);
    }

    private MemoryChunk getChunk(int n) {
        this.extendChunkListUpTo(n);
        return this.chunkList.get(n);
    }

    private void extendChunkListUpTo(int n) {
        while (n >= this.chunkList.size()) {
            this.chunkList.add(new MemoryChunk());
        }
    }

    @Override
    public void read(byte[] byArray, int n, int n2) throws DBException {
        int n3;
        if (byArray.length - n < n2) {
            throw new DBException(DBErrorCode.InvalidInput, "insufficient read buffer size:" + byArray.length + "(offset: " + n + "), byteSize = " + n2);
        }
        for (int i = n2; i > 0; i -= n3) {
            int n4 = this.chunkIndex(this.fileCursor);
            int n5 = this.chunkOffset(this.fileCursor);
            MemoryChunk memoryChunk = this.getChunk(n4);
            n3 = memoryChunk.read(byArray, n, n5, i);
            this.fileCursor += (long)n3;
            n += n3;
        }
    }

    @Override
    public void seek(long l) throws DBException {
        if (l < 0L) {
            throw new DBException(DBErrorCode.InvalidInput, "the cursor cannot be less than 0: " + l);
        }
        this.fileCursor = l;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws DBException {
        int n3;
        if (byArray.length - n < n2) {
            throw new DBException(DBErrorCode.InvalidInput, "insufficient data buffer size:" + byArray.length + "(offset: " + n + "), byteSize = " + n2);
        }
        for (int i = n2; i > 0; i -= n3) {
            int n4 = this.chunkIndex(this.fileCursor);
            int n5 = this.chunkOffset(this.fileCursor);
            MemoryChunk memoryChunk = this.getChunk(n4);
            n3 = memoryChunk.write(byArray, n, n5, i);
            this.fileCursor += (long)n3;
            n += n3;
        }
    }

    @Override
    public void close() throws DBException {
    }

    class MemoryChunk {
        byte[] buffer = new byte[1024];

        public int read(byte[] byArray, int n, int n2, int n3) {
            int n4 = 1024 - n2;
            int n5 = n4 > n3 ? n3 : n4;
            for (int i = 0; i < n5; ++i) {
                byArray[n + i] = this.buffer[n2 + i];
            }
            return n5;
        }

        public int write(byte[] byArray, int n, int n2, int n3) {
            int n4 = 1024 - n2;
            int n5 = n4 > n3 ? n3 : n4;
            for (int i = 0; i < n5; ++i) {
                this.buffer[n2 + i] = byArray[n + i];
            }
            return n5;
        }
    }
}

