/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.storage;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.xerial.db.DBErrorCode;
import org.xerial.db.DBException;
import org.xerial.db.storage.DBFile;

public class DiskFile
implements DBFile {
    private RandomAccessFile file;

    public DiskFile(String string) throws FileNotFoundException {
        this.file = new RandomAccessFile(string, "rws");
    }

    public DiskFile(String string, String string2) throws FileNotFoundException {
        this.file = new RandomAccessFile(string, string2);
    }

    @Override
    public void read(byte[] byArray, int n, int n2) throws DBException {
        assert (byArray.length >= n2);
        try {
            this.file.readFully(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new DBException(DBErrorCode.IOError, iOException);
        }
    }

    @Override
    public void seek(long l) throws DBException {
        try {
            this.file.seek(l);
        }
        catch (IOException iOException) {
            throw new DBException(DBErrorCode.IOError, iOException);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws DBException {
        try {
            this.file.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new DBException(DBErrorCode.IOError, iOException);
        }
    }

    @Override
    public void close() throws DBException {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            throw new DBException(DBErrorCode.IOError, iOException);
        }
    }
}

