/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.sql.sqlite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.xerial.core.XerialException;
import org.xerial.db.DBErrorCode;
import org.xerial.db.DBException;
import org.xerial.db.Relation;
import org.xerial.db.datatype.DataType;
import org.xerial.db.sql.RelationBuilder;
import org.xerial.db.sql.SQLExpression;
import org.xerial.db.sql.sqlite.SQLiteAccess;
import org.xerial.db.sql.sqlite.SQLiteDataTypeInfo;
import org.xerial.json.JSONObject;
import org.xerial.json.JSONValue;
import org.xerial.lens.JSONLens;
import org.xerial.util.StringUtil;
import org.xerial.util.log.Logger;

public class SQLiteCatalog {
    private static Logger _logger = Logger.getLogger(SQLiteCatalog.class);
    private SQLiteAccess _query;
    private HashMap<String, Relation> _relationTable = new HashMap();

    public SQLiteCatalog(SQLiteAccess sQLiteAccess) throws DBException {
        this._query = sQLiteAccess;
        this.searchRelations();
    }

    public void reflesh() throws DBException {
        this._relationTable.clear();
        this.searchRelations();
    }

    public Set<String> getTableNameSet() {
        return this._relationTable.keySet();
    }

    public String toJSON() {
        JSONObject jSONObject = new JSONObject();
        for (String string : this._relationTable.keySet()) {
            try {
                Relation relation = this.getRelation(string);
                JSONObject jSONObject2 = RelationBuilder.toJSON(relation);
                jSONObject.put(string, (JSONValue)jSONObject2);
            }
            catch (DBException dBException) {
                _logger.error((Object)dBException);
            }
        }
        return jSONObject.toJSONString();
    }

    private void searchRelations() throws DBException {
        String string = SQLExpression.fillTemplate("select name from sqlite_master where type = '$1'", "table");
        List<String> list = this._query.singleColumnQuery(string, "name", String.class);
        for (String string2 : list) {
            if (string2.equals("sqlite_master") || string2.equals("sqlite_sequence")) continue;
            this._relationTable.put(string2, this._query.getRelationSchema(string2));
        }
    }

    public String createValueTupleFromBean(String string, Object object) throws DBException, XerialException {
        Relation relation = this.getRelation(string);
        JSONObject jSONObject = new JSONObject(JSONLens.toJSON((Object)object));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object2 : jSONObject.keys()) {
            hashMap.put((String)object2, jSONObject.get((String)object2).toJSONString());
        }
        ArrayList arrayList = new ArrayList();
        for (DataType dataType : relation.getDataTypeList()) {
            arrayList.add(hashMap.get(dataType.getName()));
        }
        return StringUtil.join((Collection)arrayList, (String)",");
    }

    public List<SQLiteDataTypeInfo> getKeyAttributeName(String string) throws DBException {
        List<SQLiteDataTypeInfo> list = this._query.getSQLiteDataTypeInfo(string);
        ArrayList<SQLiteDataTypeInfo> arrayList = new ArrayList<SQLiteDataTypeInfo>();
        for (SQLiteDataTypeInfo sQLiteDataTypeInfo : list) {
            if (!sQLiteDataTypeInfo.isPrimaryKey()) continue;
            arrayList.add(sQLiteDataTypeInfo);
        }
        return arrayList;
    }

    private Relation getRelation(String string) throws DBException {
        Relation relation = this._relationTable.get(string);
        if (relation == null) {
            throw new DBException(DBErrorCode.TableIsNotFound, string + " table doesn't exist in the database.");
        }
        return relation;
    }
}

