/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.sql.sqlite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xerial.core.XerialException;
import org.xerial.db.DBErrorCode;
import org.xerial.db.DBException;
import org.xerial.db.Relation;
import org.xerial.db.datatype.DataType;
import org.xerial.db.datatype.DataTypeBase;
import org.xerial.db.datatype.TypeName;
import org.xerial.db.sql.ConnectionPool;
import org.xerial.db.sql.ConnectionPoolImpl;
import org.xerial.db.sql.DatabaseAccessBase;
import org.xerial.db.sql.JSONObjectReader;
import org.xerial.db.sql.JSONValueReader;
import org.xerial.db.sql.RelationBuilder;
import org.xerial.db.sql.SQLExpression;
import org.xerial.db.sql.sqlite.SQLite;
import org.xerial.db.sql.sqlite.SQLiteCatalog;
import org.xerial.db.sql.sqlite.SQLiteDataTypeInfo;
import org.xerial.json.JSONObject;
import org.xerial.json.JSONValue;
import org.xerial.lens.JSONLens;
import org.xerial.util.CollectionUtil;
import org.xerial.util.Functor;
import org.xerial.util.StringUtil;
import org.xerial.util.log.Logger;

public class SQLiteAccess
extends DatabaseAccessBase {
    private SQLiteCatalog _catalog = null;
    private static Logger _logger = Logger.getLogger(SQLiteAccess.class);

    public SQLiteAccess() throws DBException {
        super(new ConnectionPoolImpl("org.sqlite.JDBC", SQLite.getMemoryDatabaseAddress(), 1));
    }

    public SQLiteAccess(String string) throws DBException {
        super(new ConnectionPoolImpl("org.sqlite.JDBC", SQLite.getDatabaseAddress(string)));
    }

    public SQLiteAccess(ConnectionPool connectionPool) throws DBException {
        super(connectionPool);
    }

    public SQLiteCatalog getCatalog() throws DBException {
        if (this._catalog == null) {
            this._catalog = new SQLiteCatalog(this);
        }
        return this._catalog;
    }

    public Collection<String> getTableList() throws DBException {
        return this.getCatalog().getTableNameSet();
    }

    @Override
    public List<String> getTableNameList() throws DBException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : super.getTableNameList()) {
            if (string.equals("sqlite_sequence")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<SQLiteDataTypeInfo> getSQLiteDataTypeInfo(String string) throws DBException {
        String string2 = SQLExpression.fillTemplate("pragma table_info($1)", string);
        return this.query(string2, SQLiteDataTypeInfo.class);
    }

    public Relation getRelationSchema(String string) throws DBException {
        Relation relation = new Relation();
        List<SQLiteDataTypeInfo> list = this.getSQLiteDataTypeInfo(string);
        for (SQLiteDataTypeInfo sQLiteDataTypeInfo : list) {
            String string2 = sQLiteDataTypeInfo.getName();
            String string3 = sQLiteDataTypeInfo.getType();
            string3 = string3.toLowerCase();
            DataType dataType = Relation.getDataType(string2, string3);
            dataType = new DataTypeBase(string2, TypeName.STRING);
            relation.add(dataType);
        }
        return relation;
    }

    public void deleteByKeyValue(Object object, String string) throws DBException, XerialException {
        List<SQLiteDataTypeInfo> list = this.getCatalog().getKeyAttributeName(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SQLiteDataTypeInfo sQLiteDataTypeInfo : list) {
            JSONObject jSONObject = new JSONObject(JSONLens.toJSON((Object)object));
            JSONValue jSONValue = jSONObject.get(sQLiteDataTypeInfo.getName());
            if (jSONValue == null) {
                throw new DBException(DBErrorCode.InvalidDataFormat, "key value cannot be null: " + sQLiteDataTypeInfo.getName());
            }
            arrayList.add(sQLiteDataTypeInfo.getName() + "=" + jSONValue.toJSONString());
        }
        String string2 = SQLExpression.fillTemplate("delete from $1 $2", string, arrayList.size() > 0 ? "where " + StringUtil.join(arrayList, (String)" and ") : "");
        this.update(string2);
    }

    public void createTable(String string, Relation relation) throws DBException {
        List list = CollectionUtil.collectFromNonGenericCollection(relation.getDataTypeList(), (Functor)new Functor<DataType, String>(){

            public String apply(DataType dataType) {
                String string = dataType.getName() + " " + SQLite.getDataTypeName(dataType);
                if (dataType.isPrimaryKey()) {
                    string = string + " primary key";
                }
                if (dataType.isNullable()) {
                    string = string + " not null";
                }
                return string;
            }
        });
        String string2 = StringUtil.join((Collection)list, (String)", ");
        String string3 = SQLExpression.fillTemplate("create table $1 ($2)", string, string2);
        this.update(string3);
        this.getCatalog().reflesh();
    }

    public void dropTable(String string) throws DBException {
        String string2 = SQLExpression.fillTemplate("drop table $1", string);
        this.update(string2);
        this.getCatalog().reflesh();
    }

    public <T> List<T> amoebaQuery(Class<T> clazz, String string) throws DBException {
        List<String> list;
        try {
            list = RelationBuilder.extractBeanParameterList(clazz);
        }
        catch (XerialException xerialException) {
            throw new DBException(DBErrorCode.InvalidBeanClass, xerialException);
        }
        String string2 = SQLExpression.fillTemplate("select $1 from $2", StringUtil.join(list, (String)", "), string);
        return this.query(string2, clazz);
    }

    public List<JSONValue> selectColumnData(String string, String string2) throws DBException {
        return this.queryWithHandler(string, new JSONValueReader(string2));
    }

    public List<JSONObject> jsonQuery(String string) throws DBException {
        return this.queryWithHandler(string, new JSONObjectReader());
    }
}

