/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.sql.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.db.DBErrorCode;
import org.xerial.db.DBException;
import org.xerial.db.Relation;
import org.xerial.db.datatype.DataType;
import org.xerial.db.sql.DatabaseAccess;
import org.xerial.db.sql.ObjectStorage;
import org.xerial.db.sql.PreparedStatementHandler;
import org.xerial.db.sql.QueryParam;
import org.xerial.db.sql.RelationBuilder;
import org.xerial.db.sql.SQLExpression;
import org.xerial.db.sql.impl.ResultCount;
import org.xerial.util.Pair;
import org.xerial.util.Predicate;
import org.xerial.util.StringUtil;
import org.xerial.util.lens.ObjectLens;
import org.xerial.util.log.Logger;

public class ObjectStorageImpl
implements ObjectStorage {
    private static Logger _logger = Logger.getLogger(ObjectStorageImpl.class);
    private DatabaseAccess dbAccess;
    private HashSet<String> registeredTableSet = new HashSet();
    private HashMap<Class<?>, Relation> relationOfEachClass = new HashMap();
    private HashMap<Class<?>, String> tableNameOfEachClass = new HashMap();
    private HashMap<Class<?>, Class<?>> associatedClassOfOneToOneRelationship = new HashMap();

    public ObjectStorageImpl(DatabaseAccess databaseAccess) {
        this.dbAccess = databaseAccess;
    }

    public DatabaseAccess getDatabaseAccess() {
        return this.dbAccess;
    }

    public static Date getNowDate() {
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        try {
            return dateFormat.parse(dateFormat.format(date));
        }
        catch (ParseException parseException) {
            _logger.error((Object)parseException);
            throw new IllegalStateException(parseException);
        }
    }

    @Override
    public <T> T create(T t) throws DBException {
        Class<?> clazz = t.getClass();
        String string = this.getTableName(clazz);
        Relation relation = this.getRelation(clazz);
        try {
            Date date = ObjectStorageImpl.getNowDate();
            ObjectStorageImpl.setCreatedAtTimeStamp(t, date);
            ObjectStorageImpl.setModifiedAtTimeStamp(t, date);
            final Pair<List<Pair<DataType, String>>, List<byte[]>> pair = ObjectStorageImpl.retrieveColumnValueAndBlobList(relation, t);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Pair pair2 : (List)pair.getFirst()) {
                arrayList.add(pair2.getSecond());
            }
            String string2 = SQLExpression.fillTemplate("insert into $1($2) values($3)", string, StringUtil.join(ObjectStorageImpl.writableAttributeList(relation), (String)", "), StringUtil.join(arrayList, (String)", "));
            int n = this.dbAccess.insertAndRetrieveKeysWithPreparedStatement(string2, new PreparedStatementHandler(){

                @Override
                public void setup(PreparedStatement preparedStatement) throws SQLException {
                    int n = 1;
                    for (byte[] byArray : (List)pair.getSecond()) {
                        preparedStatement.setBytes(n++, byArray);
                    }
                }
            });
            ObjectStorageImpl.setBeanID(t, n);
        }
        catch (XerialException xerialException) {
            throw new DBException(DBErrorCode.UpdateError, xerialException);
        }
        return t;
    }

    private static <T> void setTimeStamp(T t, String string, Date date) throws XerialException {
        ObjectLens objectLens = ObjectLens.getObjectLens(t.getClass());
        try {
            objectLens.setParameter(t, string, (Object)date);
        }
        catch (Exception exception) {
            throw new XerialException((ErrorCode)XerialErrorCode.InvocationTargetException, (Throwable)exception);
        }
    }

    public static <T> void setCreatedAtTimeStamp(T t, Date date) throws XerialException {
        ObjectStorageImpl.setTimeStamp(t, "createdAt", date);
    }

    public static <T> void setModifiedAtTimeStamp(T t, Date date) throws XerialException {
        ObjectStorageImpl.setTimeStamp(t, "modifiedAt", date);
    }

    private <T, U> boolean isOneToOne(Class<T> clazz, Class<U> clazz2) {
        return this.associatedClassOfOneToOneRelationship.containsKey(clazz) && this.associatedClassOfOneToOneRelationship.get(clazz).equals(clazz2);
    }

    @Override
    public <T, U> U create(T t, U u) throws DBException {
        ObjectStorageImpl.setParentBeanID(t, u);
        if (this.isOneToOne(t.getClass(), u.getClass()) && this.getOne(t, u.getClass()) != null) {
            throw new DBException(DBErrorCode.AssociatedObjectAlreadyExist);
        }
        return this.create(u);
    }

    @Override
    public <T, U, V> V create(T t, U u, V v) throws DBException {
        ObjectStorageImpl.setParentBeanID(t, v);
        ObjectStorageImpl.setParentBeanID(u, v);
        return this.create(v);
    }

    @Override
    public <T, U, V> V create(Class<T> clazz, int n, Class<U> clazz2, int n2, V v) throws DBException {
        ObjectStorageImpl.setParentBeanID(clazz, n, v);
        ObjectStorageImpl.setParentBeanID(clazz2, n2, v);
        return this.create(v);
    }

    public static <T> void setBeanID(T t, int n) throws DBException {
        ObjectStorageImpl.setValue(t, "id", n);
    }

    public static <T, U> void setParentBeanID(T t, U u) throws DBException {
        int n = ObjectStorageImpl.getBeanID(t);
        ObjectStorageImpl.setParentBeanID(t.getClass(), n, u);
    }

    public static <T, U> void setParentBeanID(Class<T> clazz, int n, U u) throws DBException {
        String string = clazz.getSimpleName() + "Id";
        ObjectStorageImpl.setValue(u, string, n);
    }

    public static <T> void setValue(T t, String string, Object object) throws DBException {
        try {
            Class<?> clazz = t.getClass();
            ObjectLens objectLens = ObjectLens.getObjectLens(clazz);
            objectLens.setParameter(t, string, object);
        }
        catch (Exception exception) {
            throw new DBException(DBErrorCode.InvalidBeanClass, exception);
        }
    }

    public static <T> int getBeanID(T t) throws DBException {
        return (Integer)Integer.class.cast(ObjectStorageImpl.getValue(t, "id"));
    }

    public static <T, U> int getAssociatedBeanID(T t, Class<U> clazz) throws DBException {
        String string = ObjectStorageImpl.getAssociatedIDColumnName(clazz);
        return (Integer)Integer.class.cast(ObjectStorageImpl.getValue(t, string));
    }

    public static <T> String getAssociatedIDColumnName(Class<T> clazz) {
        String string = clazz.getSimpleName();
        return string.substring(0, 1).toLowerCase() + string.substring(1) + "Id";
    }

    public static <T> Object getValue(T t, String string) throws DBException {
        try {
            ObjectLens objectLens = ObjectLens.getObjectLens(t.getClass());
            return objectLens.getParameter(t, string);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            throw new DBException(DBErrorCode.InvalidBeanClass, exception);
        }
    }

    public static <T> Pair<List<Pair<DataType, String>>, List<byte[]>> retrieveColumnValueAndBlobList(Relation relation, T t) {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        block7: for (DataType dataType : relation.getDataTypeList()) {
            if (dataType.getName().equals("id")) continue;
            Object object = null;
            try {
                object = ObjectStorageImpl.getValue(t, dataType.getName());
            }
            catch (Exception exception) {
                _logger.error((Object)exception);
            }
            switch (dataType.getType()) {
                case INTEGER: 
                case LONG: 
                case DOUBLE: {
                    arrayList.add(new Pair((Object)dataType, (Object)(object == null ? "" : object.toString())));
                    continue block7;
                }
                case DATETIME: {
                    Object object2 = (Date)Date.class.cast(object);
                    String string = object2 == null ? "" : String.format("'%s'", DateFormat.getDateTimeInstance().format((Date)object2));
                    arrayList.add(new Pair((Object)dataType, (Object)string));
                    continue block7;
                }
                case BLOB: {
                    arrayList.add(new Pair((Object)dataType, (Object)"?"));
                    Object object2 = (byte[])byte[].class.cast(object);
                    if (object2 != null) {
                        arrayList2.add(object2);
                        continue block7;
                    }
                    arrayList2.add(new byte[0]);
                    continue block7;
                }
            }
            arrayList.add(new Pair((Object)dataType, (Object)String.format("'%s'", object == null ? "" : object.toString())));
        }
        return new Pair(arrayList, arrayList2);
    }

    public static List<String> writableAttributeList(Relation relation) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DataType dataType : relation.getDataTypeList()) {
            if (dataType.getName().equals("id")) continue;
            arrayList.add(dataType.getName());
        }
        return arrayList;
    }

    @Override
    public <T> T get(Class<T> clazz, int n) throws DBException {
        String string = this.getTableName(clazz);
        String string2 = SQLExpression.fillTemplate("select $1 from $2 where id = $3", this.getSelectColumnList(clazz), string, n);
        List<T> list = this.dbAccess.query(string2, clazz);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> T get(Class<T> clazz, String string) throws DBException {
        List<T> list = this.dbAccess.query(string, clazz);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T, U> List<U> getAll(T t, Class<U> clazz) throws DBException {
        int n = ObjectStorageImpl.getBeanID(t);
        return this.getAll(t.getClass(), n, clazz);
    }

    @Override
    public <T, U> List<U> getAllWithSorting(T t, Class<U> clazz) throws DBException {
        int n = ObjectStorageImpl.getBeanID(t);
        String string = this.getTableName(clazz);
        String string2 = ObjectStorageImpl.getAssociatedIDColumnName(t.getClass());
        String string3 = SQLExpression.fillTemplate("select $1 from $2 u where $3 = $4 order by u.id", this.getSelectColumnList(clazz, "u."), string, string2, n);
        return this.dbAccess.query(string3, clazz);
    }

    @Override
    public <T, U> List<U> getAll(T t, Class<U> clazz, QueryParam queryParam) throws DBException {
        int n = ObjectStorageImpl.getBeanID(t);
        return this.getAll(t.getClass(), n, clazz, queryParam);
    }

    @Override
    public <T, U> List<U> getAll(Class<T> clazz, int n, Class<U> clazz2) throws DBException {
        String string = this.getTableName(clazz2);
        String string2 = ObjectStorageImpl.getAssociatedIDColumnName(clazz);
        String string3 = SQLExpression.fillTemplate("select $1 from $2 where $3 = $4", this.getSelectColumnList(clazz2), string, string2, n);
        return this.dbAccess.query(string3, clazz2);
    }

    @Override
    public <T, U> List<U> getAll(Class<T> clazz, int n, Class<U> clazz2, QueryParam queryParam) throws DBException {
        String string = this.getTableName(clazz2);
        String string2 = ObjectStorageImpl.getAssociatedIDColumnName(clazz);
        String string3 = SQLExpression.fillTemplate("select $1 from $2 u where $3 = $4 $5 order by $6", this.getSelectColumnList(clazz2, "u."), string, string2, n, queryParam.getWhereCondition() != null ? "and " + queryParam.getWhereCondition() : "", queryParam.getOrderByColumns() != null ? queryParam.getOrderByColumns() : "u.id");
        return this.dbAccess.query(string3, clazz2);
    }

    @Override
    public <T> List<T> getAll(Class<T> clazz) throws DBException {
        return this.getAll(clazz, (Predicate)null);
    }

    @Override
    public <T> List<T> getAll(Class<T> clazz, String string) throws DBException {
        return this.dbAccess.query(string, clazz);
    }

    @Override
    public <T> List<T> getAll(Class<T> clazz, Predicate<T> predicate) throws DBException {
        String string = this.getTableName(clazz);
        String string2 = SQLExpression.fillTemplate("select $1 from $2", this.getSelectColumnList(clazz), string);
        if (predicate != null) {
            return this.dbAccess.query(string2, clazz, predicate);
        }
        return this.dbAccess.query(string2, clazz);
    }

    @Override
    public <T, U> U getOne(T t, Class<U> clazz) throws DBException {
        int n = ObjectStorageImpl.getBeanID(t);
        return this.getOne(t.getClass(), n, clazz);
    }

    @Override
    public <T, U> U getOne(T t, Class<U> clazz, int n) throws DBException {
        String string = this.getTableName(clazz);
        String string2 = ObjectStorageImpl.getAssociatedIDColumnName(t.getClass());
        int n2 = ObjectStorageImpl.getBeanID(t);
        String string3 = SQLExpression.fillTemplate("select $5 from $1 where $2 = $3 and id = $4", string, string2, n2, n, this.getSelectColumnList(clazz));
        List<U> list = this.dbAccess.query(string3, clazz);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public <T> String getSelectColumnList(Class<T> clazz) throws DBException {
        return this.getSelectColumnList(clazz, "");
    }

    public <T> String getSelectColumnList(Class<T> clazz, String string) throws DBException {
        Relation relation = this.getRelation(clazz);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DataType dataType : relation.getDataTypeList()) {
            arrayList.add(string + dataType.getName());
        }
        return StringUtil.join(arrayList, (String)", ");
    }

    @Override
    public <T, U, V> V get(Class<T> clazz, int n, Class<U> clazz2, int n2, Class<V> clazz3) throws DBException {
        String string = this.getTableName(clazz3);
        String string2 = ObjectStorageImpl.getAssociatedIDColumnName(clazz);
        String string3 = ObjectStorageImpl.getAssociatedIDColumnName(clazz2);
        String string4 = SQLExpression.fillTemplate("select $1 from $2 where $3 = $4 and $5 = $6", this.getSelectColumnList(clazz3), string, string2, n, string3, n2);
        List<V> list = this.dbAccess.query(string4, clazz3);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T, U> U getOne(Class<T> clazz, int n, Class<U> clazz2) throws DBException {
        String string = this.getTableName(clazz2);
        String string2 = ObjectStorageImpl.getAssociatedIDColumnName(clazz);
        String string3 = SQLExpression.fillTemplate("select $1 from $2 where $3 = $4", this.getSelectColumnList(clazz2), string, string2, n);
        List<U> list = this.dbAccess.query(string3, clazz2);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T, U> U getOne(Class<T> clazz, int n, Class<U> clazz2, int n2) throws DBException {
        String string = this.getTableName(clazz2);
        String string2 = ObjectStorageImpl.getAssociatedIDColumnName(clazz);
        String string3 = SQLExpression.fillTemplate("select $1 from $2 where $3 = $4 and id = $5", this.getSelectColumnList(clazz2), string, string2, n, n2);
        List<U> list = this.dbAccess.query(string3, clazz2);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T, U> T getParent(U u, Class<T> clazz) throws DBException {
        int n = ObjectStorageImpl.getAssociatedBeanID(u, clazz);
        String string = this.getTableName(clazz);
        String string2 = SQLExpression.fillTemplate("select $1 from $2 where id = $3", this.getSelectColumnList(clazz), string, n);
        List<T> list = this.dbAccess.query(string2, clazz);
        if (list == null || list.size() <= 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <T, U> T getParent(Class<T> clazz, Class<U> clazz2, int n) throws DBException {
        String string = this.getTableName(clazz);
        String string2 = this.getTableName(clazz2);
        String string3 = SQLExpression.fillTemplate("select $1 from $2 t, $3 u where u.id = $4", this.getSelectColumnList(clazz, "t."), string, string2, n);
        List<T> list = this.dbAccess.query(string3, clazz);
        if (list == null || list.size() <= 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <T, U> void oneToOne(Class<T> clazz, Class<U> clazz2) throws DBException {
        this.associatedClassOfOneToOneRelationship.put(clazz, clazz2);
    }

    public static <T> String createTableSchema(Relation relation) throws XerialException {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (DataType dataType : relation.getDataTypeList()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("%s %s", dataType.getName(), dataType.getTypeName()));
            if (dataType.getName().equals("id")) {
                stringBuilder.append(" primary key autoincrement not null");
                linkedList.addFirst(stringBuilder.toString());
                continue;
            }
            linkedList.add(stringBuilder.toString());
        }
        return StringUtil.join(linkedList, (String)", ");
    }

    public static <T> String createTableSchema(Class<T> clazz) throws XerialException {
        Relation relation = RelationBuilder.createRelation(clazz);
        return ObjectStorageImpl.createTableSchema(relation);
    }

    @Override
    public <T> void register(Class<T> clazz) throws DBException {
        String string = clazz.getSimpleName().toLowerCase();
        this.register(string, clazz);
    }

    @Override
    public <T> void register(String string, Class<T> clazz) throws DBException {
        if (this.registeredTableSet.contains(string) && this.tableNameOfEachClass.containsKey(clazz)) {
            return;
        }
        try {
            Relation relation = RelationBuilder.createRelation(clazz);
            if (!this.dbAccess.hasTable(string)) {
                String string2 = this.dbAccess.createTableSQL(string, relation);
                _logger.info((Object)String.format("create a new table %s", string));
                this.dbAccess.update(string2);
            }
            this.tableNameOfEachClass.put(clazz, string);
            this.relationOfEachClass.put(clazz, relation);
            this.registeredTableSet.add(string);
        }
        catch (XerialException xerialException) {
            throw new DBException(DBErrorCode.InvalidBeanClass, xerialException);
        }
    }

    private String getTableNameWithoutRegister(Class<?> clazz) {
        String string = this.tableNameOfEachClass.get(clazz);
        if (string == null) {
            return clazz.getSimpleName().toLowerCase();
        }
        return string;
    }

    private boolean isRegistered(Class<?> clazz) {
        return this.tableNameOfEachClass.get(clazz) != null;
    }

    private String getTableName(Class<?> clazz) throws DBException {
        if (!this.isRegistered(clazz)) {
            this.register(clazz);
            return this.getTableName(clazz);
        }
        return this.getTableNameWithoutRegister(clazz);
    }

    private Relation getRelation(Class<?> clazz) throws DBException {
        Relation relation = this.relationOfEachClass.get(clazz);
        if (relation == null) {
            try {
                relation = RelationBuilder.createRelation(clazz);
                this.relationOfEachClass.put(clazz, relation);
            }
            catch (XerialException xerialException) {
                throw new DBException(DBErrorCode.InvalidBeanClass, xerialException);
            }
        }
        return relation;
    }

    public static <T> Pair<String, List<byte[]>> createUpdateStatement(Relation relation, T t) {
        Pair<List<Pair<DataType, String>>, List<byte[]>> pair = ObjectStorageImpl.retrieveColumnValueAndBlobList(relation, t);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Pair pair2 : (List)pair.getFirst()) {
            String string = ((DataType)pair2.getFirst()).getName();
            if (string.equalsIgnoreCase("createdAt")) continue;
            arrayList.add(String.format("%s = %s", string, pair2.getSecond()));
        }
        return new Pair((Object)StringUtil.join(arrayList, (String)", "), pair.getSecond());
    }

    @Override
    public <T> void save(T t) throws DBException {
        Class<?> clazz = t.getClass();
        String string = this.getTableName(clazz);
        try {
            Relation relation = this.getRelation(clazz);
            int n = ObjectStorageImpl.getBeanID(t);
            Date date = ObjectStorageImpl.getNowDate();
            ObjectStorageImpl.setModifiedAtTimeStamp(t, date);
            final Pair<String, List<byte[]>> pair = ObjectStorageImpl.createUpdateStatement(relation, t);
            String string2 = SQLExpression.fillTemplate("update $1 set $2 where id = $3", string, pair.getFirst(), n);
            this.dbAccess.updateWithPreparedStatement(string2, new PreparedStatementHandler(){

                @Override
                public void setup(PreparedStatement preparedStatement) throws SQLException {
                    int n = 1;
                    for (byte[] byArray : (List)pair.getSecond()) {
                        preparedStatement.setBytes(n++, byArray);
                    }
                }
            });
        }
        catch (XerialException xerialException) {
            throw new DBException(DBErrorCode.InvalidBeanClass, xerialException);
        }
    }

    @Override
    public <T> void saveAll(Class<T> clazz, Collection<T> collection) throws DBException {
        String string = this.getTableName(clazz);
        Date date = ObjectStorageImpl.getNowDate();
        try {
            Relation relation = this.getRelation(clazz);
            this.dbAccess.update("begin transaction");
            for (T t : collection) {
                int n = ObjectStorageImpl.getBeanID(t);
                ObjectStorageImpl.setModifiedAtTimeStamp(t, date);
                final Pair<String, List<byte[]>> pair = ObjectStorageImpl.createUpdateStatement(relation, t);
                String string2 = SQLExpression.fillTemplate("update $1 set $2 where id = $3", string, pair.getFirst(), n);
                this.dbAccess.updateWithPreparedStatement(string2, new PreparedStatementHandler(){

                    @Override
                    public void setup(PreparedStatement preparedStatement) throws SQLException {
                        int n = 1;
                        for (byte[] byArray : (List)pair.getSecond()) {
                            preparedStatement.setBytes(n++, byArray);
                        }
                    }
                });
            }
            this.dbAccess.update("commit");
        }
        catch (Exception exception) {
            this.dbAccess.update("rollback");
            throw new DBException(DBErrorCode.UpdateError, exception);
        }
    }

    @Override
    public <T> T get(Class<T> clazz, QueryParam queryParam) throws DBException {
        List<T> list = this.getAll(clazz, queryParam);
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    @Override
    public <T> List<T> getAll(Class<T> clazz, QueryParam queryParam) throws DBException {
        assert (queryParam != null);
        String string = SQLExpression.fillTemplate("select $1 from $2 $3", this.getSelectColumnList(clazz), this.getTableName(clazz), queryParam.toSQLFragment());
        return this.dbAccess.query(string, clazz);
    }

    @Override
    public <T> int count(Class<T> clazz) throws DBException {
        return this.count(clazz, new QueryParam());
    }

    @Override
    public <T> int count(Class<T> clazz, QueryParam queryParam) throws DBException {
        assert (queryParam != null);
        String string = SQLExpression.fillTemplate("select count(*) as count from $1 $2", this.getTableName(clazz), queryParam.toSQLFragment());
        return this.count(string);
    }

    int count(String string) throws DBException {
        List<ResultCount> list = this.dbAccess.query(string, ResultCount.class);
        if (list.size() > 0) {
            return list.get(0).getCount();
        }
        return 0;
    }

    @Override
    public <T, U> int count(Class<T> clazz, int n, Class<U> clazz2) throws DBException {
        String string = ObjectStorageImpl.getAssociatedIDColumnName(clazz);
        String string2 = SQLExpression.fillTemplate("select count(*) as count from $1 where $2 = $3", this.getTableName(clazz2), string, n);
        return this.count(string2);
    }

    @Override
    public <T, U, V> int count(Class<T> clazz, int n, Class<U> clazz2, int n2, Class<V> clazz3) throws DBException {
        String string = ObjectStorageImpl.getAssociatedIDColumnName(clazz);
        String string2 = ObjectStorageImpl.getAssociatedIDColumnName(clazz2);
        String string3 = SQLExpression.fillTemplate("select count(*) as count from $1 where $2 = $3 and $4 = $5", this.getTableName(clazz3), string, n, string2, n2);
        return this.count(string3);
    }

    @Override
    public <T> void delete(T t) throws DBException {
        int n = ObjectStorageImpl.getBeanID(t);
        this.delete(t.getClass(), n);
    }

    @Override
    public <T> void delete(Class<T> clazz, int n) throws DBException {
        String string = SQLExpression.fillTemplate("delete from $1 where id = $2", this.getTableName(clazz), n);
        this.dbAccess.update(string);
    }

    @Override
    public <View, ObjectType> List<View> getAllFromView(Class<View> clazz, Class<ObjectType> clazz2) throws DBException {
        String string = SQLExpression.fillTemplate("select $1 from $2", this.getSelectColumnList(clazz), this.getTableName(clazz2));
        return this.getAllFromView(clazz, string);
    }

    @Override
    public <View, ObjectType> List<View> getAllFromView(Class<View> clazz, String string) throws DBException {
        return this.dbAccess.query(string, clazz);
    }

    @Override
    public <View, ObjectType> View getFromView(Class<View> clazz, Class<ObjectType> clazz2) throws DBException {
        String string = SQLExpression.fillTemplate("select $1 from $2", this.getSelectColumnList(clazz), this.getTableName(clazz2));
        return this.getFromView(clazz, string);
    }

    @Override
    public <View> View getFromView(Class<View> clazz, String string) throws DBException {
        List<View> list = this.dbAccess.query(string, clazz);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> void drop(Class<T> clazz) throws DBException {
        String string = SQLExpression.fillTemplate("drop table if exists $1", this.getTableNameWithoutRegister(clazz));
        this.dbAccess.update(string);
    }
}

