/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.sql.h2;

import java.util.LinkedList;
import org.xerial.db.DBException;
import org.xerial.db.Relation;
import org.xerial.db.datatype.DataType;
import org.xerial.db.datatype.TypeName;
import org.xerial.db.sql.ConnectionPoolImpl;
import org.xerial.db.sql.DatabaseAccessBase;
import org.xerial.util.StringUtil;

public class H2Access
extends DatabaseAccessBase {
    public static final String DRIVER_NAME = "org.h2.Driver";
    public static final String ADDRESS_PREFIX = "jdbc:h2:";

    public H2Access() throws DBException {
        super(new ConnectionPoolImpl(DRIVER_NAME, "jdbc:h2:mem:"));
    }

    public H2Access(String string) throws DBException {
        super(new ConnectionPoolImpl(DRIVER_NAME, ADDRESS_PREFIX + string));
    }

    @Override
    public String createTableSQL(String string, Relation relation) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (DataType object2 : relation.getDataTypeList()) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = object2.getTypeName();
            if (object2.getType() == TypeName.STRING) {
                string2 = "varchar";
            }
            stringBuilder.append(String.format("%s %s", object2.getName(), string2));
            if (object2.getName().equals("id")) {
                stringBuilder.append(" not null auto_increment primary key");
                linkedList.addFirst(stringBuilder.toString());
                continue;
            }
            linkedList.add(stringBuilder.toString());
        }
        String string3 = StringUtil.join(linkedList, (String)", ");
        String string4 = String.format("create table if not exists %s (%s)", string, string3);
        return string4;
    }
}

