/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.sql;

import java.util.Collection;
import java.util.Vector;

public class SQLUtil {
    private static String[] quotation = new String[]{"", "'", "\""};

    private static String separate(Collection collection, String string, QuotationType quotationType) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = quotationType.ordinal();
        for (Object e : collection) {
            stringBuilder.append(quotation[n]);
            stringBuilder.append(e.toString());
            stringBuilder.append(quotation[n]);
            stringBuilder.append(string);
        }
        if (stringBuilder.length() >= string.length()) {
            return stringBuilder.substring(0, stringBuilder.length() - string.length());
        }
        return "";
    }

    public static String commaSeparatedList(Collection collection, QuotationType quotationType) {
        return SQLUtil.separate(collection, ", ", quotationType);
    }

    public static <E> String commaSeparatedList(E[] EArray, QuotationType quotationType) {
        Vector<E> vector = new Vector<E>(EArray.length);
        for (E e : EArray) {
            vector.add(e);
        }
        return SQLUtil.commaSeparatedList(vector, quotationType);
    }

    public static String separatedList(Collection collection, String string, QuotationType quotationType) {
        return SQLUtil.separate(collection, string, quotationType);
    }

    public static String doubleQuote(String string) {
        return "\"" + string + "\"";
    }

    public static String singleQuote(String string) {
        return "'" + string + "'";
    }

    private SQLUtil() {
    }

    public static enum QuotationType {
        none,
        singleQuote,
        doubleQuote;

    }
}

