/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.sql;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xerial.db.DBErrorCode;
import org.xerial.db.DBException;

public class SQLExpression {
    private String _sqlExpr;

    public SQLExpression(String string) {
        this._sqlExpr = string;
    }

    public String assign(Object ... objectArray) throws DBException {
        String string = this._sqlExpr;
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            String string2 = "\\$" + (i + 1);
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            int n2 = matcher.start();
            Quote quote = this.withinWhatTypeOfQuote(string, n2, n = matcher.end());
            if (quote == Quote.INVALID) {
                throw new DBException(DBErrorCode.InvalidSQLExpression, "invalid quotation around $" + (i + 1) + " in " + string);
            }
            String string3 = SQLExpression.sanitize(objectArray[i] != null ? objectArray[i].toString() : "", quote);
            string = string.replaceAll(string2, string3);
        }
        return string;
    }

    private Quote withinWhatTypeOfQuote(String string, int n, int n2) {
        LinkedList<Quote> linkedList = new LinkedList<Quote>();
        linkedList.add(Quote.NONE);
        for (int i = 0; i < n; ++i) {
            if (linkedList.isEmpty()) {
                return Quote.INVALID;
            }
            if (string.charAt(i) == '\'') {
                if (linkedList.getLast() == Quote.SINGLE_QUOTE) {
                    linkedList.removeLast();
                    continue;
                }
                linkedList.addLast(Quote.SINGLE_QUOTE);
                continue;
            }
            if (string.charAt(i) != '\"') continue;
            if (linkedList.getLast() == Quote.DOUBLE_QUOTE) {
                linkedList.removeLast();
                continue;
            }
            linkedList.addLast(Quote.DOUBLE_QUOTE);
        }
        Quote quote = (Quote)((Object)linkedList.getLast());
        LinkedList<Quote> linkedList2 = new LinkedList<Quote>();
        linkedList2.add(Quote.NONE);
        for (int i = string.length() - 1; i > n2; --i) {
            if (linkedList2.isEmpty()) {
                return Quote.INVALID;
            }
            if (string.charAt(i) == '\'') {
                if (linkedList2.getLast() == Quote.SINGLE_QUOTE) {
                    linkedList2.removeLast();
                    continue;
                }
                linkedList2.addLast(Quote.SINGLE_QUOTE);
                continue;
            }
            if (string.charAt(i) != '\"') continue;
            if (linkedList2.getLast() == Quote.DOUBLE_QUOTE) {
                linkedList2.removeLast();
                continue;
            }
            linkedList2.addLast(Quote.DOUBLE_QUOTE);
        }
        Quote quote2 = (Quote)((Object)linkedList.getLast());
        if (quote == quote2) {
            return quote;
        }
        return Quote.INVALID;
    }

    public static String sanitize(String string, Quote quote) throws DBException {
        LinkedList<Quote> linkedList = new LinkedList<Quote>();
        linkedList.addLast(quote);
        for (int i = 0; i < string.length(); ++i) {
            if (linkedList.isEmpty()) {
                throw new DBException(DBErrorCode.InvalidSQLExpression, "get out from the context of " + quote.name() + ": " + string);
            }
            if (string.charAt(i) == '\'') {
                if (linkedList.getLast() == Quote.SINGLE_QUOTE) {
                    linkedList.removeLast();
                    continue;
                }
                linkedList.addLast(Quote.SINGLE_QUOTE);
                continue;
            }
            if (string.charAt(i) != '\"') continue;
            if (linkedList.getLast() == Quote.DOUBLE_QUOTE) {
                linkedList.removeLast();
                continue;
            }
            linkedList.addLast(Quote.DOUBLE_QUOTE);
        }
        linkedList.addLast(quote);
        assert (quote != Quote.INVALID);
        Quote quote2 = quote;
        while (!linkedList.isEmpty()) {
            if (linkedList.getFirst() == linkedList.getLast()) {
                quote2 = (Quote)((Object)linkedList.getFirst());
                linkedList.removeFirst();
                linkedList.removeLast();
                if (quote2 == Quote.DOUBLE_QUOTE) {
                    while (!linkedList.isEmpty() && linkedList.getFirst() == Quote.SINGLE_QUOTE) {
                        linkedList.removeFirst();
                    }
                    continue;
                }
                if (quote2 != Quote.SINGLE_QUOTE) continue;
                while (!linkedList.isEmpty() && linkedList.getFirst() == Quote.DOUBLE_QUOTE) {
                    linkedList.removeFirst();
                }
                continue;
            }
            throw new DBException(DBErrorCode.InvalidSQLExpression, "paren does not match: " + string);
        }
        return string;
    }

    public static String fillTemplate(String string, Object ... objectArray) throws DBException {
        return new SQLExpression(string).assign(objectArray);
    }

    public static enum Quote {
        SINGLE_QUOTE,
        DOUBLE_QUOTE,
        NONE,
        INVALID;

    }
}

