/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.sql;

import java.util.ArrayList;
import java.util.List;
import org.xerial.core.XerialException;
import org.xerial.db.Relation;
import org.xerial.db.datatype.DataType;
import org.xerial.json.JSONArray;
import org.xerial.json.JSONErrorCode;
import org.xerial.json.JSONException;
import org.xerial.json.JSONObject;
import org.xerial.json.JSONValue;
import org.xerial.util.bean.BeanBinder;
import org.xerial.util.bean.BeanBinderSet;
import org.xerial.util.bean.BeanUtil;
import org.xerial.util.lens.ObjectLens;
import org.xerial.util.lens.impl.ParameterSetter;

public class RelationBuilder {
    public static List<String> extractBeanParameterList(Class clazz) throws XerialException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BeanBinderSet beanBinderSet = BeanUtil.getBeanOutputRule((Class)clazz);
        for (BeanBinder beanBinder : beanBinderSet.getBindRules()) {
            String string = beanBinder.getParameterName();
            arrayList.add(string);
        }
        return arrayList;
    }

    public static JSONObject toJSON(Relation relation) {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        for (DataType dataType : relation.getDataTypeList()) {
            JSONArray jSONArray2 = new JSONArray();
            jSONArray2.add(dataType.getName());
            jSONArray2.add(dataType.getTypeName());
            jSONArray.add((JSONValue)jSONArray2);
        }
        jSONObject.put("relation", (JSONValue)jSONArray);
        return jSONObject;
    }

    public static Relation createRelation(String string) throws JSONException {
        Relation relation = new Relation();
        JSONObject jSONObject = new JSONObject(string);
        JSONArray jSONArray = jSONObject.getJSONArray("relation");
        if (jSONArray == null) {
            throw new JSONException(JSONErrorCode.InvalidJSONData, "no relation is found");
        }
        for (int i = 0; i < jSONArray.size(); ++i) {
            try {
                JSONArray jSONArray2 = jSONArray.getJSONArray(i);
                if (jSONArray2.size() != 2) {
                    throw new JSONException(JSONErrorCode.InvalidJSONData);
                }
                String string2 = jSONArray2.get(0).toString();
                String string3 = jSONArray2.get(1).toString();
                DataType dataType = Relation.getDataType(string2, string3);
                relation.add(dataType);
                continue;
            }
            catch (JSONException jSONException) {
                throw new JSONException(JSONErrorCode.InvalidJSONData, jSONArray.toString() + " does not contain a pair of [param_name, data_type_str]");
            }
        }
        return relation;
    }

    public static Relation createRelation(Class<?> clazz) throws XerialException {
        return new BeanToRelationProcess().createRelation(clazz);
    }

    private static class BeanToRelationProcess {
        private Relation _relation = new Relation();

        public Relation createRelation(Class<?> clazz) throws XerialException {
            if (clazz == null) {
                return this._relation;
            }
            ObjectLens objectLens = ObjectLens.getObjectLens(clazz);
            for (ParameterSetter parameterSetter : objectLens.getSetterList()) {
                Class clazz2 = parameterSetter.getParameterType();
                String string = parameterSetter.getCanonicalParameterName();
                DataType dataType = Relation.getDataType(string, clazz2);
                this._relation.add(dataType);
            }
            return this._relation;
        }
    }
}

