/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.xerial.db.DBErrorCode;
import org.xerial.db.DBException;
import org.xerial.db.sql.ConnectionPool;
import org.xerial.util.log.Logger;

public class NaiveConnectionPool
implements ConnectionPool {
    private static Logger _logger = Logger.getLogger(NaiveConnectionPool.class);
    private String driver;
    private String address;

    public NaiveConnectionPool(String string, String string2) {
        this.driver = string;
        this.address = string2;
        _logger.debug((Object)("driver: " + string));
        _logger.debug((Object)("addredss: " + string2));
    }

    @Override
    public void closeAll() throws DBException {
    }

    @Override
    public Connection getConnection() throws DBException {
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DBException(DBErrorCode.UnknownJDBCDriver, classNotFoundException);
        }
        try {
            Connection connection = DriverManager.getConnection(this.address);
            return connection;
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.JDBCConnectionError, sQLException);
        }
    }

    @Override
    public void returnConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            _logger.error((Object)sQLException);
        }
    }
}

