/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.sql;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.xerial.core.XerialException;
import org.xerial.db.DBErrorCode;
import org.xerial.db.DBException;
import org.xerial.db.Relation;
import org.xerial.db.datatype.DataType;
import org.xerial.db.sql.BeanResultHandler;
import org.xerial.db.sql.ColumnReader;
import org.xerial.db.sql.ConnectionPool;
import org.xerial.db.sql.DatabaseAccess;
import org.xerial.db.sql.PreparedStatementHandler;
import org.xerial.db.sql.ResultSetHandler;
import org.xerial.db.sql.SQLExpression;
import org.xerial.json.JSONObject;
import org.xerial.json.JSONUtil;
import org.xerial.json.JSONValue;
import org.xerial.lens.Lens;
import org.xerial.util.Predicate;
import org.xerial.util.StringUtil;
import org.xerial.util.bean.BeanHandler;
import org.xerial.util.bean.BeanUtil;
import org.xerial.util.log.Logger;

public class DatabaseAccessBase
implements DatabaseAccess {
    private ConnectionPool _connectionPool;
    private static Logger _logger = Logger.getLogger(DatabaseAccessBase.class);
    private int queryTimeout = 60;
    private boolean autoCommit = true;
    private HashMap<String, Relation> tableRelationCatalog = new HashMap();

    public DatabaseAccessBase(ConnectionPool connectionPool) throws DBException {
        this._connectionPool = connectionPool;
        Connection connection = this._connectionPool.getConnection();
        this._connectionPool.returnConnection(connection);
    }

    @Override
    public void dispose() throws DBException {
        this._connectionPool.closeAll();
    }

    protected Statement createStatement(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.setQueryTimeout(this.queryTimeout);
        return statement;
    }

    @Override
    public <T> void query(String string, ResultSetHandler<T> resultSetHandler) throws DBException {
        Connection connection = null;
        try {
            connection = this.getConnection(true);
            Statement statement = this.createStatement(connection);
            _logger.debug((Object)string);
            resultSetHandler.init();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                resultSetHandler.handle(resultSet);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.QueryError, sQLException);
        }
        finally {
            if (connection != null) {
                this._connectionPool.returnConnection(connection);
            }
            resultSetHandler.finish();
        }
    }

    @Override
    public <T> List<T> query(String string, Class<T> clazz) throws DBException {
        BeanCollector beanCollector = new BeanCollector();
        this.query(string, clazz, beanCollector);
        return beanCollector.result;
    }

    @Override
    public <T> List<T> query(String string, Class<T> clazz, Predicate<T> predicate) throws DBException {
        BeanCollectorWithPredicate<T> beanCollectorWithPredicate = new BeanCollectorWithPredicate<T>(predicate);
        this.query(string, clazz, beanCollectorWithPredicate);
        return beanCollectorWithPredicate.result;
    }

    @Override
    public <T> void query(String string, Class<T> clazz, BeanResultHandler<T> beanResultHandler) throws DBException {
        Redirector<T> redirector = new Redirector<T>(beanResultHandler);
        Connection connection = null;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            try {
                connection = this.getConnection(true);
                statement = this.createStatement(connection);
                _logger.debug((Object)string);
                resultSet = statement.executeQuery(string);
                redirector.handler.init();
                Lens.loadJDBCResultSet(clazz, (ResultSet)resultSet, redirector);
                redirector.handler.finish();
            }
            catch (Exception exception) {
                throw new DBException(DBErrorCode.QueryError, exception);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    this._connectionPool.returnConnection(connection);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.QueryError, sQLException);
        }
    }

    @Override
    public <T> T accumulate(String string, ResultSetHandler<T> resultSetHandler) throws DBException {
        Connection connection = null;
        T t = null;
        try {
            connection = this.getConnection(true);
            Statement statement = this.createStatement(connection);
            _logger.debug((Object)string);
            resultSetHandler.init();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                t = resultSetHandler.handle(resultSet);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.QueryError, sQLException);
        }
        finally {
            if (connection != null) {
                this._connectionPool.returnConnection(connection);
            }
            resultSetHandler.finish();
        }
        return t;
    }

    private PreparedStatement getPreparedStatement(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setQueryTimeout(this.queryTimeout);
        return preparedStatement;
    }

    @Override
    public int updateWithPreparedStatement(String string, PreparedStatementHandler preparedStatementHandler) throws DBException {
        Connection connection = null;
        try {
            connection = this.getConnection(false);
            _logger.debug((Object)string);
            PreparedStatement preparedStatement = this.getPreparedStatement(connection, string);
            preparedStatementHandler.setup(preparedStatement);
            int n = preparedStatement.executeUpdate();
            preparedStatement.close();
            int n2 = n;
            return n2;
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.UpdateError, sQLException);
        }
        finally {
            if (connection != null) {
                this._connectionPool.returnConnection(connection);
            }
        }
    }

    @Override
    public int update(String string) throws DBException {
        return this.update(string, this.autoCommit);
    }

    @Override
    public int update(String string, boolean bl) throws DBException {
        Connection connection = null;
        try {
            connection = this.getConnection(false);
            connection.setAutoCommit(bl);
            Statement statement = this.createStatement(connection);
            _logger.debug((Object)string);
            int n = statement.executeUpdate(string);
            statement.close();
            int n2 = n;
            return n2;
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.UpdateError, sQLException);
        }
        finally {
            if (connection != null) {
                this._connectionPool.returnConnection(connection);
            }
        }
    }

    @Override
    public <T> int insertAndRetrieveKeys(String string) throws DBException {
        Connection connection = null;
        try {
            connection = this.getConnection(false);
            connection.setAutoCommit(this.autoCommit);
            Statement statement = this.createStatement(connection);
            _logger.debug((Object)string);
            int n = statement.executeUpdate(string);
            ResultSet resultSet = statement.getGeneratedKeys();
            int n2 = resultSet == null ? -1 : resultSet.getInt(1);
            resultSet.close();
            statement.close();
            int n3 = n2;
            return n3;
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.UpdateError, sQLException);
        }
        finally {
            if (connection != null) {
                this._connectionPool.returnConnection(connection);
            }
        }
    }

    public ConnectionPool getConnectionPool() {
        return this._connectionPool;
    }

    private Connection getConnection(boolean bl) throws DBException, SQLException {
        Connection connection = this._connectionPool.getConnection();
        connection.setAutoCommit(this.autoCommit);
        return connection;
    }

    @Override
    public void setAutoCommit(boolean bl) {
        this.autoCommit = bl;
    }

    @Override
    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public Set<String> getPrimaryKeyColumns(String string) throws DBException {
        Connection connection = null;
        try {
            connection = this.getConnection(true);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            Set<String> set = this.getPrimaryKeyColumns(databaseMetaData, string);
            return set;
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.QueryError, sQLException);
        }
        finally {
            if (connection != null) {
                this._connectionPool.returnConnection(connection);
            }
        }
    }

    public Set<String> getPrimaryKeyColumns(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, string);
        while (resultSet.next()) {
            String string2 = resultSet.getString("COLUMN_NAME");
            hashSet.add(string2);
        }
        resultSet.close();
        return hashSet;
    }

    @Override
    public Relation getRelation(String string) throws DBException {
        if (this.tableRelationCatalog.containsKey(string)) {
            return this.tableRelationCatalog.get(string);
        }
        Relation relation = new Relation();
        Connection connection = null;
        try {
            connection = this.getConnection(true);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            Set<String> set = this.getPrimaryKeyColumns(databaseMetaData, string);
            int n = 1;
            ResultSet resultSet = databaseMetaData.getColumns(null, null, string, null);
            while (resultSet.next()) {
                String string2 = resultSet.getString("COLUMN_NAME");
                String string3 = resultSet.getString("TYPE_NAME");
                DataType dataType = Relation.getDataType(string2, string3);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                assert (dataType != null);
                dataType.setNullable(resultSet.getInt("NULLABLE") == 1);
                dataType.setPrimaryKey(set.contains(string2));
                relation.add(dataType);
                ++n;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.QueryError, sQLException);
        }
        finally {
            if (connection != null) {
                this._connectionPool.returnConnection(connection);
            }
        }
        this.tableRelationCatalog.put(string, relation);
        return relation;
    }

    @Override
    public List<String> getTableNameList() throws DBException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection = null;
        try {
            connection = this.getConnection(true);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, "%", new String[]{"TABLE", "VIEW"});
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("TABLE_NAME").toLowerCase());
            }
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.QueryError, sQLException);
        }
        finally {
            if (connection != null) {
                this._connectionPool.returnConnection(connection);
            }
        }
        return arrayList;
    }

    @Override
    public <T> List<T> singleColumnQuery(String string, String string2, Class<T> clazz) throws DBException {
        return this.queryWithHandler(string, new ColumnReader(string2));
    }

    protected <T> List<T> queryWithHandler(String string, ResultSetHandler<T> resultSetHandler) throws DBException {
        Connection connection = null;
        ArrayList<T> arrayList = new ArrayList<T>();
        try {
            connection = this.getConnection(true);
            Statement statement = this.createStatement(connection);
            _logger.debug((Object)string);
            resultSetHandler.init();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                T t = resultSetHandler.handle(resultSet);
                if (t != null) {
                    arrayList.add(t);
                    continue;
                }
                _logger.warn((Object)"null handler result is returned");
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.QueryError, sQLException);
        }
        finally {
            if (connection != null) {
                this._connectionPool.returnConnection(connection);
            }
            resultSetHandler.finish();
        }
        return arrayList;
    }

    @Override
    public <T> int insert(String string, T t) throws DBException {
        try {
            String string2 = SQLExpression.fillTemplate("insert into $1 values($2)", string, this.createValueTupleFromBean(string, t));
            return this.update(string2);
        }
        catch (XerialException xerialException) {
            throw new DBException(DBErrorCode.InvalidBeanClass, xerialException);
        }
    }

    protected String createValueTupleFromBean(String string, Object object) throws DBException, XerialException {
        Relation relation = this.getRelation(string);
        JSONObject jSONObject = new JSONObject(JSONUtil.toJSON((Object)object));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DataType dataType : relation.getDataTypeList()) {
            JSONValue jSONValue = jSONObject.get(dataType.getName());
            String string2 = jSONValue == null ? "" : jSONValue.toJSONString();
            arrayList.add(string2);
        }
        return StringUtil.join(arrayList, (String)",");
    }

    @Override
    public <T> void toJSON(String string, Class<T> clazz, Writer writer) throws DBException, IOException {
        writer.append("{");
        writer.append(StringUtil.quote((String)clazz.getSimpleName().toLowerCase(), (String)"\""));
        writer.append(":[\n");
        Connection connection = null;
        try {
            connection = this.getConnection(true);
            Statement statement = this.createStatement(connection);
            _logger.debug((Object)string);
            int n = 0;
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                if (n > 0) {
                    writer.append(",\n");
                }
                writer.append(BeanUtil.toJSONFromResultSet((ResultSet)resultSet));
                ++n;
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.QueryError, sQLException);
        }
        finally {
            if (connection != null) {
                this._connectionPool.returnConnection(connection);
            }
            writer.append("]}");
        }
    }

    @Override
    public boolean hasTable(String string) throws DBException {
        return this.getTableNameList().contains(string);
    }

    @Override
    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public int insertAndRetrieveKeysWithPreparedStatement(String string, PreparedStatementHandler preparedStatementHandler) throws DBException {
        Connection connection = null;
        try {
            connection = this.getConnection(false);
            connection.setAutoCommit(this.autoCommit);
            PreparedStatement preparedStatement = this.getPreparedStatement(connection, string);
            preparedStatementHandler.setup(preparedStatement);
            int n = preparedStatement.executeUpdate();
            ResultSet resultSet = preparedStatement.getGeneratedKeys();
            int n2 = -1;
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
            int n3 = n2;
            return n3;
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.UpdateError, sQLException);
        }
        finally {
            if (connection != null) {
                this._connectionPool.returnConnection(connection);
            }
        }
    }

    @Override
    public String createTableSQL(String string, Relation relation) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (DataType object2 : relation.getDataTypeList()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("%s %s", object2.getName(), object2.getTypeName()));
            if (object2.getName().equals("id")) {
                stringBuilder.append(" primary key autoincrement not null");
                linkedList.addFirst(stringBuilder.toString());
                continue;
            }
            linkedList.add(stringBuilder.toString());
        }
        String string2 = StringUtil.join(linkedList, (String)", ");
        String string3 = String.format("create table if not exists %s (%s)", string, string2);
        return string3;
    }

    private static class Redirector<T>
    implements BeanHandler<T> {
        final BeanResultHandler<T> handler;

        public Redirector(BeanResultHandler<T> beanResultHandler) {
            this.handler = beanResultHandler;
        }

        public void handle(T t) throws Exception {
            this.handler.handle(t);
        }

        public void handleException(Exception exception) throws Exception {
            this.handler.handleException(exception);
        }
    }

    private static class BeanCollectorWithPredicate<T>
    extends BeanCollector<T> {
        private final Predicate<T> pred;

        public BeanCollectorWithPredicate(Predicate<T> predicate) {
            this.pred = predicate;
        }

        @Override
        public void handle(T t) throws Exception {
            if (t != null && this.pred.apply(t)) {
                this.result.add(t);
            }
        }

        @Override
        public void finish() {
        }

        @Override
        public void init() {
        }
    }

    private static class BeanCollector<T>
    implements BeanResultHandler<T> {
        ArrayList<T> result = new ArrayList();

        private BeanCollector() {
        }

        @Override
        public void handle(T t) throws Exception {
            if (t != null) {
                this.result.add(t);
            }
        }

        @Override
        public void finish() {
        }

        @Override
        public void init() {
        }

        @Override
        public void handleException(Exception exception) throws Exception {
            throw exception;
        }
    }
}

