/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedList;
import org.xerial.db.DBErrorCode;
import org.xerial.db.DBException;
import org.xerial.db.sql.ConnectionPool;
import org.xerial.util.StringUtil;

public class ConnectionPoolImpl
implements ConnectionPool {
    private LinkedList<Connection> _connectionQueue = new LinkedList();
    private int _timeOutSecond = 10;
    private String _driver;
    private String _address;
    private int _numMaximumConnections = 5;

    public ConnectionPoolImpl(String string, String string2) throws DBException {
        this(string, string2, 1);
    }

    public ConnectionPoolImpl(String string, String string2, int n) throws DBException {
        this._driver = string;
        this._address = string2;
        this._numMaximumConnections = n;
        this.establishConnections();
    }

    public ConnectionPoolImpl(String string, String string2, String string3, String string4) throws DBException {
        this(string, string2, string3, string4, 1);
    }

    public ConnectionPoolImpl(String string, String string2, String string3, String string4, int n) throws DBException {
        this._driver = string;
        this._address = string2;
        this._numMaximumConnections = n;
        this.establishConnections(string3, string4);
    }

    public synchronized void establishConnections(String string, String string2) throws DBException {
        try {
            Class.forName(this._driver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DBException(DBErrorCode.UnknownJDBCDriver, classNotFoundException);
        }
        try {
            for (int i = 0; i < this._numMaximumConnections; ++i) {
                Connection connection = DriverManager.getConnection(this._address, string, string2);
                this._connectionQueue.add(connection);
            }
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.JDBCConnectionError, sQLException);
        }
    }

    public synchronized void establishConnections() throws DBException {
        try {
            Class.forName(this._driver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DBException(DBErrorCode.UnknownJDBCDriver, classNotFoundException);
        }
        try {
            for (int i = 0; i < this._numMaximumConnections; ++i) {
                Connection connection = DriverManager.getConnection(this._address);
                this._connectionQueue.add(connection);
            }
        }
        catch (SQLException sQLException) {
            throw new DBException(DBErrorCode.SQLiteDBFileNotFound, sQLException);
        }
    }

    public synchronized void add(Connection connection) {
        this._connectionQueue.add(connection);
    }

    @Override
    public synchronized Connection getConnection() throws DBException {
        try {
            while (this._connectionQueue.isEmpty()) {
                this.wait(this._timeOutSecond * 10);
            }
            Connection connection = this._connectionQueue.getFirst();
            this._connectionQueue.removeFirst();
            return connection;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new DBException(DBErrorCode.ThreadInterruption, interruptedException);
        }
    }

    @Override
    public synchronized void returnConnection(Connection connection) {
        this._connectionQueue.add(connection);
        this.notify();
    }

    @Override
    public synchronized void closeAll() throws DBException {
        this.notifyAll();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Connection connection : this._connectionQueue) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                linkedList.add(sQLException.getMessage());
            }
        }
        if (!linkedList.isEmpty()) {
            throw new DBException(DBErrorCode.FailureOnConnectionClose, StringUtil.join(linkedList, (String)", "));
        }
    }
}

