/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.model;

import org.xerial.db.model.Relationship;

public class EdgeData
implements Comparable<EdgeData> {
    private int id;
    private int src;
    private int dest;
    private int relationship = -1;

    public EdgeData() {
    }

    public EdgeData(int n, int n2, int n3, Relationship relationship) {
        this.id = n;
        this.src = n2;
        this.dest = n3;
        switch (relationship) {
            case OneToOne: {
                this.relationship = 0;
                break;
            }
            case OneToMany: {
                this.relationship = 1;
                break;
            }
            case ManyToMany: {
                this.relationship = 2;
                break;
            }
            default: {
                this.relationship = 3;
            }
        }
    }

    public int getDest() {
        return this.dest;
    }

    public void setDest(int n) {
        this.dest = n;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getRelationship() {
        return this.relationship;
    }

    public static Relationship translate(int n) {
        switch (n) {
            case 0: {
                return Relationship.OneToOne;
            }
            case 1: {
                return Relationship.OneToMany;
            }
            case 2: {
                return Relationship.ManyToMany;
            }
        }
        return Relationship.Other;
    }

    public void setRelationship(int n) {
        this.relationship = n;
    }

    public int getSrc() {
        return this.src;
    }

    public void setSrc(int n) {
        this.src = n;
    }

    @Override
    public int compareTo(EdgeData edgeData) {
        return this.id - edgeData.id;
    }
}

