/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.xerial.db.DBException;
import org.xerial.db.Relation;
import org.xerial.db.datatype.DataTypeBase;
import org.xerial.db.datatype.TypeName;
import org.xerial.db.model.DataModelInfo;
import org.xerial.db.model.EdgeData;
import org.xerial.db.model.NodeData;
import org.xerial.db.model.Relationship;
import org.xerial.db.sql.sqlite.SQLiteAccess;
import org.xerial.db.sql.sqlite.SQLiteDataTypeInfo;
import org.xerial.util.CollectionUtil;
import org.xerial.util.Functor;
import org.xerial.util.Predicate;
import org.xerial.util.graph.AdjacencyList;
import org.xerial.util.graph.DepthFirstSearchBase;
import org.xerial.util.graph.Edge;
import org.xerial.util.graph.Graph;
import org.xerial.util.log.Logger;

public class DataModel {
    private static Logger _logger = Logger.getLogger(DataModel.class);
    private AdjacencyList<String, Relationship> _graph = new AdjacencyList();

    public void addNode(String string) {
        if (!this.contains(string)) {
            this._graph.addNode((Object)string);
        }
    }

    public boolean contains(String string) {
        return this._graph.hasNode((Object)string);
    }

    public void connectNodes(String string, String string2, Relationship relationship) throws DBException {
        this._graph.addEdge((Object)string, (Object)string2, (Object)relationship);
    }

    public Set<String> getRootNodeNameSet() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : this._graph.getNodeLabelSet()) {
            if (this._graph.getInEdgeSet((Object)string).size() != 0) continue;
            treeSet.add(string);
        }
        return treeSet;
    }

    public List<String> destinationOf(String string) {
        Collection collection = this._graph.getDestNodeIDSetOf(this._graph.getNodeID((Object)string));
        return CollectionUtil.collect((Iterable)collection, (Functor)new Functor<Integer, String>(){

            public String apply(Integer n) {
                return (String)DataModel.this._graph.getNodeLabel(n.intValue());
            }
        });
    }

    public List<String> path(String string, String string2) {
        return new PathSearch().getPath(string, string2);
    }

    public boolean hasPath(String string, String string2) {
        return this.path(string, string2).size() > 0;
    }

    public void save(SQLiteAccess sQLiteAccess) throws DBException {
        if (sQLiteAccess.hasTable("node")) {
            sQLiteAccess.dropTable("node");
        }
        if (sQLiteAccess.hasTable("edge")) {
            sQLiteAccess.dropTable("edge");
        }
        Relation relation = new Relation();
        relation.add(new DataTypeBase("id", TypeName.INTEGER, true, true));
        relation.add(new DataTypeBase("name", TypeName.STRING));
        sQLiteAccess.createTable("node", relation);
        Relation relation2 = new Relation();
        relation2.add(new DataTypeBase("id", TypeName.INTEGER, true, true));
        relation2.add(new DataTypeBase("src", TypeName.INTEGER));
        relation2.add(new DataTypeBase("dest", TypeName.INTEGER));
        relation2.add(new DataTypeBase("relationship", TypeName.INTEGER));
        sQLiteAccess.createTable("edge", relation2);
        Vector<NodeData> vector = new Vector<NodeData>();
        Object object = this._graph.getNodeIDSet().iterator();
        while (object.hasNext()) {
            int n = (Integer)object.next();
            vector.add(new NodeData(n, (String)this._graph.getNodeLabel(n)));
        }
        object = new Vector();
        for (Edge object2 : this._graph.getEdgeSet()) {
            ((Vector)object).add(new EdgeData(this._graph.getEdgeID(object2), object2.getSourceNodeID(), object2.getDestNodeID(), (Relationship)((Object)this._graph.getEdgeLabel(object2))));
        }
        for (NodeData nodeData : vector) {
            sQLiteAccess.insert("node", nodeData);
        }
        Iterator iterator = ((Vector)object).iterator();
        while (iterator.hasNext()) {
            EdgeData edgeData = (EdgeData)iterator.next();
            sQLiteAccess.insert("edge", edgeData);
        }
    }

    public void load(SQLiteAccess sQLiteAccess) throws DBException {
        TreeSet treeSet = CollectionUtil.sort(sQLiteAccess.amoebaQuery(NodeData.class, "node"));
        TreeSet treeSet2 = CollectionUtil.sort(sQLiteAccess.amoebaQuery(EdgeData.class, "edge"));
        for (Comparable<NodeData> comparable : treeSet) {
            this._graph.addNode((Object)((NodeData)comparable).getName());
        }
        for (Comparable<NodeData> comparable : treeSet2) {
            this._graph.addEdge(new Edge(((EdgeData)comparable).getSrc(), ((EdgeData)comparable).getDest()), (Object)EdgeData.translate(((EdgeData)comparable).getRelationship()));
        }
    }

    public String toString() {
        return this._graph.toString();
    }

    public void attachSQLiteDatabase(String string) throws DBException {
        SQLiteAccess sQLiteAccess = new SQLiteAccess(string);
        Collection<String> collection = sQLiteAccess.getTableList();
        List list = CollectionUtil.select(collection, (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                return DataModel.isInfoTable(string);
            }
        });
        List list2 = CollectionUtil.select(collection, (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                return !DataModel.isInfoTable(string);
            }
        });
        for (String string2 : list) {
            for (DataModelInfo object : sQLiteAccess.amoebaQuery(DataModelInfo.class, string2)) {
            }
        }
        for (String string2 : list2) {
            Relation relation = new Relation();
            for (SQLiteDataTypeInfo sQLiteDataTypeInfo : sQLiteAccess.getSQLiteDataTypeInfo(string2)) {
                relation.add(Relation.getDataType(sQLiteDataTypeInfo.getName(), sQLiteDataTypeInfo.getType()));
            }
            this.addRelation(relation);
        }
    }

    public void addRelation(Relation relation) {
        _logger.debug((Object)("add relation: " + relation.toString()));
    }

    private static boolean isInfoTable(String string) {
        return string.endsWith("_info");
    }

    public boolean hasEdge(String string, String string2) {
        return this._graph.hasEdge((Object)string, (Object)string2);
    }

    public Relationship getRelationship(String string, String string2) {
        return (Relationship)((Object)this._graph.getEdgeLabel((Object)string, (Object)string2));
    }

    class PathSearch
    extends DepthFirstSearchBase<String, Relationship> {
        PathSearch() {
        }

        public List<String> getPath(String string, String string2) {
            String string3;
            this.run((Graph)DataModel.this._graph, string);
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string2);
            String string4 = string2;
            while (!(string3 = (String)this.getPredecessor(string4)).equals(string4)) {
                linkedList.addFirst(string3);
                if (string3.equals(string)) {
                    return linkedList;
                }
                string4 = string3;
            }
            if (!((String)linkedList.getFirst()).equals(string)) {
                return new LinkedList<String>();
            }
            return linkedList;
        }
    }
}

