/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.heap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.xerial.db.CommonPageHeader;
import org.xerial.db.DBErrorCode;
import org.xerial.db.DBException;
import org.xerial.db.Tuple;
import org.xerial.db.TupleComparator;
import org.xerial.db.TupleFactory;
import org.xerial.db.cache.Buffer;
import org.xerial.db.cache.BufferReader;
import org.xerial.db.cache.BufferWriter;

public class HeapPage
implements Iterable<Tuple> {
    private final CommonPageHeader header = new CommonPageHeader();
    private int numEntries = 0;
    private int entrySizeTotal = 0;
    private final int bufferSize;
    private int freeSpaceSize;
    private final ArrayList<Tuple> tupleList = new ArrayList();

    public HeapPage(int n) {
        this.header.setPageType(400);
        this.bufferSize = n;
        this.freeSpaceSize = n - this.getHeaderSize();
    }

    public int getHeaderSize() {
        return this.header.getHeaderSize() + 8 + 8;
    }

    public void append(Tuple tuple) throws DBException {
        int n = tuple.getByteSize();
        int n2 = n + 4;
        if (this.freeSpaceSize < n2) {
            throw new DBException(DBErrorCode.PageIsFull, "no enough space");
        }
        this.tupleList.add(tuple);
        ++this.numEntries;
        this.freeSpaceSize -= n2;
    }

    public void sortTuples(TupleComparator tupleComparator) {
        Collections.sort(this.tupleList, tupleComparator);
    }

    public void loadFrom(Buffer buffer, TupleFactory tupleFactory) throws DBException {
        assert (buffer.size() == this.bufferSize);
        this.tupleList.clear();
        BufferReader bufferReader = new BufferReader(buffer);
        this.header.load(bufferReader);
        this.numEntries = bufferReader.readInt();
        this.entrySizeTotal = bufferReader.readInt();
        int n = buffer.size() - 4;
        for (int i = 0; i < this.numEntries; ++i) {
            int n2 = buffer.readInt(n);
            Tuple tuple = tupleFactory.createTupleFromBuffer(new BufferReader(buffer, n2));
            this.tupleList.add(tuple);
            n -= 4;
        }
        if (this.header.getPageType() != 400) {
            throw new DBException(DBErrorCode.InvalidPageHeader, "not the heap page type: " + this.header.getPageType());
        }
    }

    public void saveTo(Buffer buffer) {
        assert (buffer.size() == this.bufferSize);
        BufferWriter bufferWriter = new BufferWriter(buffer);
        this.header.save(bufferWriter);
        bufferWriter.writeInt(this.numEntries);
        bufferWriter.writeInt(this.entrySizeTotal);
        int n = this.bufferSize - 4;
        for (Tuple tuple : this.tupleList) {
            int n2 = bufferWriter.getCursorPosition();
            tuple.save(bufferWriter);
            buffer.writeInt(n, n2);
            n -= 4;
        }
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.tupleList.iterator();
    }
}

