/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.datatype;

import org.xerial.db.datatype.DataType;
import org.xerial.db.datatype.TypeName;

public class DataTypeBase
implements DataType {
    private final String name;
    private final TypeName typeName;
    private boolean isPrimaryKey = false;
    private boolean isNullable = false;

    public DataTypeBase(String string, TypeName typeName) {
        this(string, typeName, false, false);
    }

    public DataTypeBase(String string, TypeName typeName, boolean bl) {
        this(string, typeName, bl, false);
    }

    public DataTypeBase(String string, TypeName typeName, boolean bl, boolean bl2) {
        this.name = string;
        this.typeName = typeName;
        this.isPrimaryKey = bl;
        this.isNullable = bl2;
    }

    @Override
    public int compareTo(DataType dataType) {
        return this.getName().compareTo(dataType.getName());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DataType)) {
            return false;
        }
        return this.getName().equals(((DataType)object).getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeName getType() {
        return this.typeName;
    }

    @Override
    public String getTypeName() {
        return this.typeName.getTypeName();
    }

    @Override
    public void setPrimaryKey(boolean bl) {
        this.isPrimaryKey = bl;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    @Override
    public void setNullable(boolean bl) {
        this.isNullable = bl;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    public String toString() {
        return String.format("%s (%s)", this.getName(), this.getTypeName() + (this.isPrimaryKey ? " pkey" : ""));
    }
}

