/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.cache;

import java.util.ArrayList;
import java.util.Stack;
import org.xerial.db.cache.Buffer;

public class PageCacheHolder {
    private int pageSize;
    private int numPageCacheMax;
    private ArrayList<Buffer> pageCacheList = new ArrayList();
    private Stack<Buffer> freePageCacheHolder = new Stack();

    public PageCacheHolder(int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("num page cache must be higher than 0: " + n2);
        }
        if (n <= 0) {
            throw new IllegalArgumentException("page size must be higher than 0: " + n);
        }
        this.numPageCacheMax = n2;
        this.preparePageCache();
    }

    private void preparePageCache() {
        this.pageCacheList.clear();
        this.freePageCacheHolder.clear();
        for (int i = 0; i < this.numPageCacheMax; ++i) {
            this.pageCacheList.add(new Buffer(this.pageSize));
        }
        for (Buffer buffer : this.pageCacheList) {
            this.freePageCacheHolder.add(buffer);
        }
    }

    public Buffer getPageCache() {
        if (this.freePageCacheHolder.empty()) {
            return null;
        }
        return this.freePageCacheHolder.pop();
    }
}

