/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.cache;

import org.xerial.db.cache.Buffer;

public class BufferWriter {
    private final Buffer buffer;
    private int offset;

    public BufferWriter(Buffer buffer) {
        this(buffer, 0);
    }

    public BufferWriter(Buffer buffer, int n) {
        this.buffer = buffer;
        this.offset = n;
    }

    public int getCursorPosition() {
        return this.offset;
    }

    public void writeInt(int n) {
        this.buffer.writeInt(this.offset, n);
        this.offset += 4;
    }

    public void writeByte(byte by) {
        this.buffer.writeByte(this.offset, by);
        ++this.offset;
    }

    public void writeLong(long l) {
        this.buffer.writeLong(this.offset, l);
        this.offset += 8;
    }

    public void writeBoolean(boolean bl) {
        this.buffer.writeBoolean(this.offset, bl);
        ++this.offset;
    }
}

