/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.btree;

import org.xerial.db.CommonPageHeader;
import org.xerial.db.PageHeader;
import org.xerial.db.cache.BufferReader;
import org.xerial.db.cache.BufferWriter;

public class BTreePageHeader
implements PageHeader {
    private final CommonPageHeader defaultHeader = new CommonPageHeader();
    private int numEntries = 0;
    private boolean isDirty = false;

    public long getPageID() {
        return this.defaultHeader.getPageID();
    }

    public void setPageID(long l) {
        this.defaultHeader.setPageID(l);
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public void setNumEntries(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("numEntries cannot be less than 0: " + n);
        }
        this.numEntries = n;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public void save(BufferWriter bufferWriter) {
        this.defaultHeader.save(bufferWriter);
        bufferWriter.writeInt(this.numEntries);
        bufferWriter.writeBoolean(this.isDirty);
    }

    public void load(BufferReader bufferReader) {
        this.defaultHeader.load(bufferReader);
        this.numEntries = bufferReader.readInt();
        this.isDirty = bufferReader.readBoolean();
    }

    @Override
    public int getHeaderSize() {
        return this.defaultHeader.getHeaderSize() + 5;
    }
}

