/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.benchmark;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Random;
import org.xerial.util.StopWatch;
import org.xerial.util.log.Logger;
import org.xerial.util.opt.Option;
import org.xerial.util.opt.OptionParser;
import org.xerial.util.opt.OptionParserException;

public class StorageBench {
    private static Logger _logger = Logger.getLogger(StorageBench.class);
    private final Config config;

    public StorageBench(Config config) {
        this.config = config;
    }

    public static void main(String[] stringArray) {
        Config config = new Config();
        OptionParser optionParser = new OptionParser((Object)config);
        try {
            optionParser.parse(stringArray);
            new StorageBench(config).run();
        }
        catch (OptionParserException optionParserException) {
            System.err.println((Object)optionParserException);
            optionParser.printUsage();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        StopWatch stopWatch = new StopWatch();
        byte[] byArray = new byte[this.config.blockSizeInKB * 1024];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)i;
        }
        File file = null;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            File file2 = new File(this.config.directory, "bench");
            file2.mkdirs();
            file = File.createTempFile("storage-bench", ".bench", file2);
            _logger.info((Object)("preparing a test bench file: " + file.getAbsolutePath()));
            int n5 = this.config.tmpFileSizeInMB * 1024 * 1024;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rwd");
            int n6 = 0;
            int n7 = 0;
            while (n6 < n5) {
                randomAccessFile.write(byArray);
                n6 += this.config.blockSizeInKB * 1024;
                ++n7;
            }
            _logger.info((Object)("preparation done. page count = " + n7));
            int n8 = n5 / (this.config.blockSizeInKB * 1024);
            randomAccessFile.close();
            randomAccessFile = new RandomAccessFile(file, "rwd");
            byte[] byArray2 = new byte[this.config.blockSizeInKB * 1024];
            stopWatch.reset();
            for (n4 = 0; n4 < this.config.repeat; ++n4) {
                randomAccessFile.seek(0L);
                for (n3 = 0; n3 < n7; ++n3) {
                    randomAccessFile.readFully(byArray);
                }
            }
            this.reportMBSec("sequential scan", stopWatch.getElapsedTime());
            stopWatch.reset();
            for (n4 = 0; n4 < this.config.repeat; ++n4) {
                randomAccessFile.seek(0L);
                for (n3 = 0; n3 < n7; ++n3) {
                    randomAccessFile.write(byArray);
                }
            }
            this.reportMBSec("sequential write", stopWatch.getElapsedTime());
            randomAccessFile.seek(0L);
            Random random = new Random();
            stopWatch.reset();
            for (n3 = 0; n3 < this.config.repeat; ++n3) {
                for (n2 = 0; n2 < n7; ++n2) {
                    n = random.nextInt(n8);
                    randomAccessFile.seek(this.config.blockSizeInKB * n);
                    randomAccessFile.readFully(byArray2);
                }
            }
            this.reportIOPS("random read", stopWatch.getElapsedTime());
            random = new Random();
            stopWatch.reset();
            for (n3 = 0; n3 < this.config.repeat; ++n3) {
                for (n2 = 0; n2 < n7; ++n2) {
                    n = random.nextInt(n8);
                    randomAccessFile.seek(this.config.blockSizeInKB * n);
                    randomAccessFile.write(byArray);
                }
            }
            this.reportIOPS("random write", stopWatch.getElapsedTime());
            randomAccessFile.close();
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    private void reportMBSec(String string, double d) {
        int n = this.config.tmpFileSizeInMB * 1024 / this.config.blockSizeInKB;
        int n2 = n * this.config.blockSizeInKB * 1024 * this.config.repeat;
        double d2 = (double)(n2 / 1024 / 1024) / d;
        _logger.info((Object)String.format("%10s\t%5.2f MB/sec.", string, d2));
    }

    private void reportIOPS(String string, double d) {
        int n = this.config.tmpFileSizeInMB * 1024 * 1024 / (this.config.blockSizeInKB * 1024);
        int n2 = n * this.config.repeat;
        double d2 = (double)n2 / d;
        _logger.info((Object)String.format("%10s:\t%8.2f IOPS.", string, d2));
    }

    public static class Config {
        @Option(symbol="d", description="target disk drive name")
        public String directory = "C:";
        @Option(symbol="b", description="block size in KB (default = 8)")
        public int blockSizeInKB = 4;
        @Option(symbol="t", description="total target data size in MB (default = 100)")
        public int tmpFileSizeInMB = 100;
        public int numTrial = 1000;
        public int repeat = 1;
    }
}

