/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db.benchmark;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.Random;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.util.opt.Option;
import org.xerial.util.opt.OptionParser;
import org.xerial.util.opt.OptionParserException;
import org.xerial.xml.XMLAttribute;
import org.xerial.xml.XMLGenerator;

public class BenchmarkTableGenerator {
    @Option(symbol="h", longName="help", description="display help message")
    private boolean displayHelp = false;
    @Option(symbol="f", longName="fanout", varName="FANOUT", description="set fanout. default=2")
    private int fanout = 2;
    @Option(symbol="c", longName="column", varName="NUM", description="set table column size. default = 3")
    private int numColumn = 4;
    @Option(symbol="s", longName="scalability", varName="FACTOR", description="scalability factor. default = 0.1")
    private double factor = 0.1;
    @Option(symbol="m", longName="mode", varName="MODE", description="0: simple, 1: hierarchical, 2: random")
    private int modeNum = 0;
    @Option(symbol="o", longName="output", varName="FILE", description="output file name")
    private String outFile = null;
    private Mode mode = Mode.SIMPLE;
    private Writer out = new OutputStreamWriter(System.out);
    private boolean isReady = true;
    private OptionParser optionParser = new OptionParser((Object)this);
    private String[] colName;

    public BenchmarkTableGenerator(String[] stringArray) throws OptionParserException {
        this.optionParser.parse(stringArray);
        if (this.displayHelp) {
            this.optionParser.printUsage();
            this.isReady = false;
        }
        switch (this.modeNum) {
            case 0: {
                this.mode = Mode.SIMPLE;
                break;
            }
            case 1: {
                this.mode = Mode.HIERARCHICAL;
                break;
            }
            case 2: {
                this.mode = Mode.RANDOM;
                break;
            }
            default: {
                throw new OptionParserException((ErrorCode)XerialErrorCode.PARSE_ERROR, "Unknown mode: " + this.modeNum);
            }
        }
        if (this.outFile != null) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.outFile));
                this.out = bufferedWriter;
            }
            catch (IOException iOException) {
                throw new OptionParserException((ErrorCode)XerialErrorCode.IO_EXCEPTION, (Throwable)iOException);
            }
        }
    }

    public void generate() throws IOException {
        int n;
        this.colName = new String[this.numColumn + 1];
        this.colName[0] = "item";
        for (int i = 1; i < this.colName.length; ++i) {
            n = 97 + i - 1;
            this.colName[i] = String.valueOf((char)n);
        }
        XMLGenerator xMLGenerator = new XMLGenerator(this.out);
        xMLGenerator.startTag("table");
        n = (int)(this.factor * 1000.0);
        switch (this.mode) {
            case SIMPLE: {
                Simple simple = new Simple(n, xMLGenerator);
                simple.generate();
                break;
            }
            case HIERARCHICAL: {
                Hierarchical hierarchical = new Hierarchical(n, xMLGenerator);
                hierarchical.generate();
                break;
            }
            case RANDOM: {
                RandomGen randomGen = new RandomGen(n, xMLGenerator);
                randomGen.generate();
            }
        }
        xMLGenerator.endTag();
        xMLGenerator.endDocument();
        xMLGenerator.flush();
        this.out.close();
    }

    public String getColName(int n) {
        return this.colName[n];
    }

    public static void main(String[] stringArray) {
        try {
            BenchmarkTableGenerator benchmarkTableGenerator = new BenchmarkTableGenerator(stringArray);
            if (benchmarkTableGenerator.isReady) {
                benchmarkTableGenerator.generate();
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public class Simple {
        int numRow;
        XMLGenerator xmlOut;
        int[] value;

        public Simple(int n, XMLGenerator xMLGenerator) {
            int n2;
            this.value = new int[BenchmarkTableGenerator.this.numColumn];
            this.numRow = n;
            this.xmlOut = xMLGenerator;
            for (n2 = 0; n2 < this.value.length; ++n2) {
                this.value[n2] = 1;
            }
            n2 = (int)Math.pow(BenchmarkTableGenerator.this.fanout, (double)BenchmarkTableGenerator.this.numColumn - 1.0);
            int n3 = n / n2 + (n % n2 == 0 ? 0 : 1);
        }

        public void generate() {
            int n = 0;
            while (this.numRow > 0) {
                this.xmlOut.startTag("item", new XMLAttribute("value", ++n));
                this.process(1);
                this.xmlOut.endTag();
            }
        }

        private void process(int n) {
            if (this.numRow <= 0) {
                return;
            }
            if (n >= BenchmarkTableGenerator.this.numColumn) {
                int n2;
                for (n2 = 1; n2 < BenchmarkTableGenerator.this.numColumn; ++n2) {
                    this.xmlOut.startTag(BenchmarkTableGenerator.this.getColName(n2), new XMLAttribute("value", this.value[n2]));
                }
                for (n2 = 1; n2 < BenchmarkTableGenerator.this.numColumn; ++n2) {
                    this.xmlOut.endTag();
                }
                this.xmlOut.flush();
                --this.numRow;
                return;
            }
            int n3 = n == 0 ? 1 : BenchmarkTableGenerator.this.fanout;
            for (int i = 0; i < n3; ++i) {
                this.value[n] = i + 1;
                this.process(n + 1);
            }
        }
    }

    public class RandomGen {
        int numRow;
        XMLGenerator xmlOut;
        Random r = new Random(40L);

        public RandomGen(int n, XMLGenerator xMLGenerator) {
            this.numRow = n;
            this.xmlOut = xMLGenerator;
            int n2 = (int)Math.pow(BenchmarkTableGenerator.this.fanout, BenchmarkTableGenerator.this.numColumn);
            int n3 = n / n2 + (n % n2 == 0 ? 0 : 1);
        }

        private boolean canHaveMulpleNodes(LinkedList<Integer> linkedList, int n) {
            int n2;
            int n3 = linkedList.get(n);
            int n4 = -1;
            for (n2 = 0; n2 < n; ++n2) {
                int n5 = linkedList.get(n2);
                if (n5 > n3) {
                    return false;
                }
                if (n4 >= n5) continue;
                n4 = n5;
            }
            for (n2 = n + 1; n2 < linkedList.size(); ++n2) {
                if (n4 <= linkedList.get(n2)) continue;
                return false;
            }
            return true;
        }

        private int smallestFDColumnIndex(LinkedList<Integer> linkedList, int n) {
            for (int i = 0; i < n; ++i) {
                int n2 = linkedList.get(i);
                for (int j = linkedList.size() - 1; j >= n; --j) {
                    int n3 = linkedList.get(j);
                    if (n2 <= n3) continue;
                    return i;
                }
            }
            return -1;
        }

        public void generate() {
            int n = 0;
            while (this.numRow > 0) {
                LinkedList<Integer> linkedList = new LinkedList<Integer>();
                for (int i = 1; i < BenchmarkTableGenerator.this.numColumn; ++i) {
                    linkedList.add(i);
                }
                LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
                while (!linkedList.isEmpty()) {
                    int n2 = this.r.nextInt(linkedList.size());
                    int n3 = (Integer)linkedList.remove(n2);
                    linkedList2.add(n3);
                }
                this.xmlOut.startTag("item", new XMLAttribute("value", ++n));
                this.process(linkedList2, 0, new LinkedList<Element>());
                this.xmlOut.endTag();
            }
        }

        private void process(LinkedList<Integer> linkedList, int n, LinkedList<Element> linkedList2) {
            if (n >= linkedList.size()) {
                --this.numRow;
                return;
            }
            int n2 = linkedList.get(n);
            int n3 = this.smallestFDColumnIndex(linkedList, n);
            if (n3 == -1) {
                n3 = n;
            }
            for (int i = 0; i < BenchmarkTableGenerator.this.fanout; ++i) {
                Element element = new Element(n2, i + 1);
                linkedList2.add(element);
                this.xmlOut.startTag(BenchmarkTableGenerator.this.getColName(element.col), new XMLAttribute("value", element.value));
                this.process(linkedList, n + 1, linkedList2);
                this.xmlOut.endTag();
                if (this.numRow <= 0) {
                    linkedList2.removeLast();
                    break;
                }
                if (i < BenchmarkTableGenerator.this.fanout - 1) {
                    int n4;
                    for (n4 = n - 1; n4 >= n3; --n4) {
                        this.xmlOut.endTag();
                    }
                    for (n4 = n3; n4 < n; ++n4) {
                        Element element2 = linkedList2.get(n4);
                        this.xmlOut.startTag(BenchmarkTableGenerator.this.getColName(element2.col), new XMLAttribute("value", element2.value));
                    }
                }
                linkedList2.removeLast();
            }
        }

        class Element {
            int col;
            int value;

            public Element(int n, int n2) {
                this.col = n;
                this.value = n2;
            }
        }
    }

    public class Hierarchical {
        int numRow;
        XMLGenerator xmlOut;

        public Hierarchical(int n, XMLGenerator xMLGenerator) {
            this.numRow = n;
            this.xmlOut = xMLGenerator;
            int n2 = (int)Math.pow(BenchmarkTableGenerator.this.fanout, BenchmarkTableGenerator.this.numColumn);
            int n3 = n / n2 + (n % n2 == 0 ? 0 : 1);
        }

        public void generate() {
            int n = 0;
            while (this.numRow > 0) {
                this.process(0, n++);
            }
        }

        private void process(int n, int n2) {
            if (n >= BenchmarkTableGenerator.this.numColumn) {
                this.xmlOut.flush();
                --this.numRow;
                return;
            }
            int n3 = n == 0 ? 1 : BenchmarkTableGenerator.this.fanout;
            for (int i = 0; i < n3; ++i) {
                this.xmlOut.startTag(BenchmarkTableGenerator.this.getColName(n), new XMLAttribute("value", i + 1 + n2));
                this.process(n + 1, 0);
                this.xmlOut.endTag();
                if (this.numRow > 0) continue;
                return;
            }
        }
    }

    private static enum Opt {
        HELP,
        FANOUT,
        COLUMN,
        SCALABILITY_FACTOR,
        MODE,
        OUTPUT;

    }

    private static enum Mode {
        SIMPLE,
        HIERARCHICAL,
        RANDOM;

    }
}

