/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Vector;
import org.xerial.db.DBErrorCode;
import org.xerial.db.DBException;
import org.xerial.db.cache.BufferWriter;

public class VariableLengthInteger {
    private static int[] upperBoundByByteSize;
    byte[] _binaryRepresentation = null;

    public VariableLengthInteger(int n) {
        this.translate(n);
    }

    public VariableLengthInteger(byte[] byArray, int n) throws DBException {
        this.translate(byArray, n);
    }

    public byte[] getByte() {
        assert (this._binaryRepresentation != null);
        return this._binaryRepresentation;
    }

    public int size() {
        assert (this._binaryRepresentation != null);
        return this._binaryRepresentation.length;
    }

    public int intValue() {
        assert (this._binaryRepresentation != null);
        int n = 0;
        for (int i = 0; i < this._binaryRepresentation.length; ++i) {
            n <<= 7;
            n |= this._binaryRepresentation[i] & 0x7F;
        }
        if (this._binaryRepresentation.length > 1) {
            n += upperBoundByByteSize[this._binaryRepresentation.length - 2] + 1;
        }
        return n;
    }

    private void translate(int n) {
        int n2;
        int n3;
        for (n3 = 1; n3 <= upperBoundByByteSize.length && n > upperBoundByByteSize[n3 - 1]; ++n3) {
        }
        if (n3 > 1) {
            n -= upperBoundByByteSize[n3 - 2] + 1;
        }
        this._binaryRepresentation = new byte[n3];
        int n4 = 127 << (n3 - 1) * 7;
        for (n2 = 0; n2 < n3; ++n2) {
            this._binaryRepresentation[n2] = (byte)((n & n4) >> (n3 - (n2 + 1)) * 7);
            n4 >>= 7;
        }
        n2 = 0;
        while (n2 < this._binaryRepresentation.length - 1) {
            int n5 = n2++;
            this._binaryRepresentation[n5] = (byte)(this._binaryRepresentation[n5] | 0x80);
        }
    }

    public static int byteSize(byte[] byArray, int n) throws DBException {
        int n2 = 1;
        int n3 = n;
        while ((byArray[n3++] & 0x80) != 0) {
            if (++n2 <= upperBoundByByteSize.length) continue;
            throw new DBException(DBErrorCode.InvalidDataFormat, "cannot read the variable length integer whose bite size is larger than " + upperBoundByByteSize.length);
        }
        return n2;
    }

    public static int byteSize(int n) {
        int n2;
        for (n2 = 1; n2 <= upperBoundByByteSize.length && n > upperBoundByByteSize[n2 - 1]; ++n2) {
        }
        return n2;
    }

    public static int readFrom(byte[] byArray, int n) throws DBException {
        int n2 = 0;
        int n3 = VariableLengthInteger.byteSize(byArray, n);
        if (n3 > 4 && (n3 != 5 || byArray[n] <= 135)) {
            throw new DBException(DBErrorCode.InvalidDataFormat, "value larger than 2^31-1 cannot be read");
        }
        for (int i = 0; i < n3; ++i) {
            n2 <<= 7;
            n2 |= byArray[n + i] & 0x7F;
        }
        return n2;
    }

    public static VariableLengthInteger readFrom(ByteArrayInputStream byteArrayInputStream) throws DBException {
        int n;
        byte[] byArray = new byte[upperBoundByByteSize.length];
        int n2 = 0;
        while (((n = byteArrayInputStream.read()) & 0x80) != 0) {
            byArray[n2++] = (byte)n;
        }
        return new VariableLengthInteger(byArray, 0);
    }

    private void translate(byte[] byArray, int n) throws DBException {
        for (int i = n; i < byArray.length; ++i) {
            if ((byArray[i] & 0x80) != 0) continue;
            int n2 = i - n + 1;
            this._binaryRepresentation = new byte[n2];
            for (int j = 0; j < n2; ++j) {
                this._binaryRepresentation[j] = byArray[n + j];
            }
            return;
        }
        throw new DBException(DBErrorCode.InvalidDataFormat, "invalid code");
    }

    public int writeTo(BufferWriter bufferWriter) {
        for (int i = 0; i < this._binaryRepresentation.length; ++i) {
            bufferWriter.writeByte(this._binaryRepresentation[i]);
        }
        return this._binaryRepresentation.length;
    }

    static {
        Vector<Integer> vector = new Vector<Integer>();
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger bigInteger2 = BigInteger.valueOf(Integer.MAX_VALUE);
        int n = 1;
        BigInteger bigInteger3 = BigInteger.ZERO;
        while (bigInteger.compareTo(bigInteger2) < 0 && (bigInteger = bigInteger.add(bigInteger3 = BigInteger.ZERO.setBit(n++ * 7))).compareTo(bigInteger2) <= 0) {
            vector.add(bigInteger.subtract(BigInteger.ONE).intValue());
        }
        upperBoundByByteSize = new int[vector.size()];
        int n2 = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            VariableLengthInteger.upperBoundByByteSize[n2++] = n3;
        }
    }
}

