/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db;

import java.util.ArrayList;
import org.xerial.db.DBError;
import org.xerial.db.DBErrorCode;
import org.xerial.db.Tuple;
import org.xerial.db.TupleContainer;

public class TupleList
extends ArrayList<Tuple>
implements TupleContainer {
    private static final long serialVersionUID = 1L;
    private int capacity = 8192;
    private int currentTupleSizeTotal = 0;

    @Override
    public boolean add(Tuple tuple) {
        int n = tuple.getByteSize();
        if (!this.hasCapacityFor(tuple)) {
            throw new DBError(DBErrorCode.ExceedsTheCapacity, "exceeds the container capacity");
        }
        this.capacity -= n;
        return super.add(tuple);
    }

    @Override
    public boolean hasCapacityFor(Tuple tuple) {
        return this.currentTupleSizeTotal + tuple.getByteSize() < this.capacity;
    }
}

