/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db;

import org.xerial.db.AbstractTuple;
import org.xerial.db.Relation;
import org.xerial.db.VariableLengthInteger;
import org.xerial.db.cache.BufferReader;
import org.xerial.db.cache.BufferWriter;
import org.xerial.db.datatype.DataType;

public class TupleImpl
extends AbstractTuple {
    private final String[] value;

    public TupleImpl(Relation relation, String[] stringArray) {
        super(relation);
        this.value = stringArray;
    }

    @Override
    public Object getValue(int n) {
        throw new UnsupportedOperationException("getValue");
    }

    @Override
    public void setValue(int n, Object object) {
        throw new UnsupportedOperationException("setValue");
    }

    @Override
    public int getByteSize() {
        int n = 0;
        Relation relation = this.getRelation();
        int n2 = 0;
        for (DataType dataType : relation.getDataTypeList()) {
            switch (dataType.getType()) {
                case INTEGER: {
                    n += 4;
                    break;
                }
                case STRING: {
                    int n3 = this.value[n2].length();
                    n += VariableLengthInteger.byteSize(n3);
                    n += n3;
                    break;
                }
                case BOOLEAN: {
                    ++n;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported data type: " + dataType.getName());
                }
            }
            ++n2;
        }
        return n;
    }

    @Override
    public int load(BufferReader bufferReader) {
        int n = 0;
        Relation relation = this.getRelation();
        for (DataType dataType : relation.getDataTypeList()) {
            switch (dataType.getType()) {
                case INTEGER: {
                    int n2 = bufferReader.readInt();
                    break;
                }
                case BOOLEAN: {
                    int n2 = this.value[n].length();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported data type: " + dataType.getName());
                }
            }
            ++n;
        }
        return 0;
    }

    @Override
    public int save(BufferWriter bufferWriter) {
        return 0;
    }
}

