/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xerial.db.datatype.DataType;
import org.xerial.db.datatype.DataTypeBase;
import org.xerial.db.datatype.TypeName;
import org.xerial.json.JSONArray;
import org.xerial.json.JSONErrorCode;
import org.xerial.json.JSONException;
import org.xerial.json.JSONObject;

public class Relation {
    private ArrayList<DataType> dataTypeList = new ArrayList();

    public Relation() {
    }

    public Relation(String string) throws JSONException {
        JSONObject jSONObject = new JSONObject(string);
        this.parse(jSONObject);
    }

    public Relation(JSONObject jSONObject) throws JSONException {
        this.parse(jSONObject);
    }

    private void parse(JSONObject jSONObject) throws JSONException {
        if (jSONObject == null) {
            throw new JSONException(JSONErrorCode.InvalidJSONData, "null json object");
        }
        if (!jSONObject.hasKey("relation")) {
            throw new JSONException(JSONErrorCode.InvalidJSONData, "no relation key found");
        }
        JSONArray jSONArray = jSONObject.getJSONArray("relation");
        if (jSONArray == null) {
            return;
        }
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONArray jSONArray2 = jSONArray.getJSONArray(i);
            if (jSONArray2 == null || jSONArray2.size() != 2) {
                throw new JSONException(JSONErrorCode.InvalidJSONData, "data type must be json array with two elements: " + jSONArray.toString());
            }
            String string = jSONArray2.getString(0);
            String string2 = jSONArray2.getString(1);
            this.add(Relation.getDataType(string, string2));
        }
    }

    public static DataType getDataType(String string, String string2) {
        if (string2.equalsIgnoreCase("boolean")) {
            return new DataTypeBase(string, TypeName.BOOLEAN);
        }
        if (string2.equalsIgnoreCase("int") || string2.equalsIgnoreCase("integer") || string2.equals("serial")) {
            return new DataTypeBase(string, TypeName.INTEGER);
        }
        if (string2.equalsIgnoreCase("string")) {
            return new DataTypeBase(string, TypeName.STRING);
        }
        if (string2.equalsIgnoreCase("double")) {
            return new DataTypeBase(string, TypeName.DOUBLE);
        }
        if (string2.equalsIgnoreCase("long")) {
            return new DataTypeBase(string, TypeName.LONG);
        }
        if (string2.equalsIgnoreCase("password")) {
            return new DataTypeBase(string, TypeName.PASSWORD);
        }
        if (string2.equalsIgnoreCase("text")) {
            return new DataTypeBase(string, TypeName.TEXT);
        }
        if (string2.equalsIgnoreCase("datetime")) {
            return new DataTypeBase(string, TypeName.DATETIME);
        }
        if (string2.equalsIgnoreCase("blob")) {
            return new DataTypeBase(string, TypeName.BLOB);
        }
        return new DataTypeBase(string, TypeName.STRING);
    }

    public static <T> DataType getDataType(String string, Class<T> clazz) {
        if (clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Integer.TYPE)) {
            return new DataTypeBase(string, TypeName.INTEGER);
        }
        if (clazz.isAssignableFrom(String.class)) {
            return new DataTypeBase(string, TypeName.STRING);
        }
        if (clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE)) {
            return new DataTypeBase(string, TypeName.DOUBLE);
        }
        if (clazz.isAssignableFrom(Boolean.class) || clazz.isAssignableFrom(Boolean.TYPE)) {
            return new DataTypeBase(string, TypeName.BOOLEAN);
        }
        if (clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Long.TYPE)) {
            return new DataTypeBase(string, TypeName.LONG);
        }
        if (clazz.isAssignableFrom(Date.class)) {
            return new DataTypeBase(string, TypeName.DATETIME);
        }
        if (clazz.isAssignableFrom(byte[].class)) {
            return new DataTypeBase(string, TypeName.BLOB);
        }
        return new DataTypeBase(string, TypeName.STRING);
    }

    public void add(DataType dataType) {
        this.dataTypeList.add(dataType);
    }

    public DataType getDataType(int n) {
        return this.dataTypeList.get(n);
    }

    public int getDataTypeIndex(String string) {
        int n = 0;
        for (DataType dataType : this.dataTypeList) {
            if (dataType.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException("unknown parameter: " + string);
    }

    public List<DataType> getDataTypeList() {
        return this.dataTypeList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (DataType dataType : this.dataTypeList) {
            stringBuffer.append(dataType.toString());
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

