/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db;

import java.lang.reflect.Field;
import java.util.HashSet;
import org.xerial.util.log.Logger;

public class PageType {
    public static final int Unknown = 0;
    public static final int DatabaseInformation = 100;
    public static final int BTreeRoot = 200;
    public static final int BTreeInternalNode = 201;
    public static final int BTreeLeaf = 202;
    public static final int BTreeData = 203;
    public static final int FreePageBitMap = 300;
    public static final int Heap = 400;
    public static final int HeapIndex = 401;
    private static final HashSet<Integer> pageTypeTable;
    private static final Logger logger;

    public static boolean isValidPageType(int n) {
        return pageTypeTable.contains(n);
    }

    private PageType() {
    }

    static {
        Field[] fieldArray;
        pageTypeTable = new HashSet();
        logger = Logger.getLogger(PageType.class);
        PageType pageType = new PageType();
        for (Field field : fieldArray = PageType.class.getFields()) {
            try {
                int n = field.getInt(pageType);
                logger.trace((Object)("PageType: " + n + " " + field.getName()));
                pageTypeTable.add(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error((Object)illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.error((Object)illegalAccessException);
            }
        }
    }
}

