/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.db;

import org.xerial.db.PageHeader;
import org.xerial.db.PageType;
import org.xerial.db.cache.BufferReader;
import org.xerial.db.cache.BufferWriter;

public class CommonPageHeader
implements PageHeader {
    private long pageID = -1L;
    private int pageType = 0;

    public long getPageID() {
        return this.pageID;
    }

    public void setPageID(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid page ID: " + l);
        }
        this.pageID = l;
    }

    public int getPageType() {
        return this.pageType;
    }

    public void setPageType(int n) {
        if (!PageType.isValidPageType(n)) {
            throw new IllegalArgumentException("invalid page type: " + n);
        }
        this.pageType = n;
    }

    public void save(BufferWriter bufferWriter) {
        bufferWriter.writeLong(this.getPageID());
        bufferWriter.writeInt(this.getPageType());
    }

    public void load(BufferReader bufferReader) {
        this.setPageID(bufferReader.readLong());
        this.setPageType(bufferReader.readInt());
    }

    @Override
    public int getHeaderSize() {
        return 12;
    }
}

