package com.dabenxiang.genesisassistant.model.enums;

public enum LogLevel {
    DEBUG("assistant_debug", 0), INFO("assistant_info", 1), DEVICE_INFO("assistant_device_info", 1), WARN("assistant_warn", 2), API_LOG("assistant_api_log", 3), ERROR("assistant_error", 3), PANIC("assistant_panic", 4), FATAL("assistant_fatal", 5);

    private String name;
    private int index;

    LogLevel(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public static String getName(int index) {
        for (LogLevel c : LogLevel.values()) {
            if (c.getIndex() == index) {
                return c.name;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public int getIndex() {
        return index;
    }
}
