/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.jcr.index;

import java.util.HashMap;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.modeshape.jcr.api.Session;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.Path;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.annotations.View;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.jcrom.runtime.JcrRepository;
import org.wisdom.monitor.service.MonitorExtension;

@Path(value="/monitor/jcr/index")
@Authenticated(value="Monitor-Authenticator")
@Controller
public class IndexMonitorExtension
extends DefaultController
implements MonitorExtension,
Pojo {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexMonitorExtension.class);
    private boolean __FindexTemplate;
    @View(value="index/index")
    Template indexTemplate;
    private boolean __FjcrRepository;
    @Requires
    JcrRepository jcrRepository;
    boolean __Mindex;
    boolean __MrebuildIndex;
    boolean __Mlabel;
    boolean __Murl;
    boolean __Mcategory;

    Template __getindexTemplate() {
        if (!this.__FindexTemplate) {
            return this.indexTemplate;
        }
        return (Template)this.__IM.onGet((Object)this, "indexTemplate");
    }

    void __setindexTemplate(Template template) {
        if (!this.__FindexTemplate) {
            this.indexTemplate = template;
            return;
        }
        this.__IM.onSet((Object)this, "indexTemplate", (Object)template);
    }

    JcrRepository __getjcrRepository() {
        if (!this.__FjcrRepository) {
            return this.jcrRepository;
        }
        return (JcrRepository)this.__IM.onGet((Object)this, "jcrRepository");
    }

    void __setjcrRepository(JcrRepository jcrRepository) {
        if (!this.__FjcrRepository) {
            this.jcrRepository = jcrRepository;
            return;
        }
        this.__IM.onSet((Object)this, "jcrRepository", (Object)jcrRepository);
    }

    public IndexMonitorExtension() {
        this(null);
    }

    private IndexMonitorExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Route(uri="", method=HttpMethod.GET)
    public Result index() throws Exception {
        Result result;
        if (!this.__Mindex) {
            return this.__M_index();
        }
        try {
            this.__IM.onEntry((Object)this, "index", new Object[0]);
            result = this.__M_index();
            this.__IM.onExit((Object)this, "index", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "index", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_index() throws Exception {
        Session session = (Session)this.__getjcrRepository().getSession();
        HashMap<String, String> indexes = new HashMap<String, String>();
        for (IndexDefinition index : session.getWorkspace().getIndexManager().getIndexDefinitions().values()) {
            indexes.put(index.getName(), session.getWorkspace().getIndexManager().getIndexStatus(index.getProviderName(), index.getName(), session.getWorkspace().getName()).name());
        }
        return IndexMonitorExtension.ok((Object)this.render(this.__getindexTemplate(), new Object[]{"indexes", indexes.entrySet()}));
    }

    @Route(uri="/index/rebuild", method=HttpMethod.POST)
    public Result rebuildIndex() throws Exception {
        Result result;
        if (!this.__MrebuildIndex) {
            return this.__M_rebuildIndex();
        }
        try {
            this.__IM.onEntry((Object)this, "rebuildIndex", new Object[0]);
            result = this.__M_rebuildIndex();
            this.__IM.onExit((Object)this, "rebuildIndex", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "rebuildIndex", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_rebuildIndex() throws Exception {
        Session session = (Session)this.__getjcrRepository().getSession();
        session.getWorkspace().reindexAsync();
        return this.index();
    }

    public String label() {
        String string;
        if (!this.__Mlabel) {
            return this.__M_label();
        }
        try {
            this.__IM.onEntry((Object)this, "label", new Object[0]);
            string = this.__M_label();
            this.__IM.onExit((Object)this, "label", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "label", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_label() {
        return "Index Monitor";
    }

    public String url() {
        String string;
        if (!this.__Murl) {
            return this.__M_url();
        }
        try {
            this.__IM.onEntry((Object)this, "url", new Object[0]);
            string = this.__M_url();
            this.__IM.onExit((Object)this, "url", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "url", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_url() {
        return "/monitor/jcr/index";
    }

    public String category() {
        String string;
        if (!this.__Mcategory) {
            return this.__M_category();
        }
        try {
            this.__IM.onEntry((Object)this, "category", new Object[0]);
            string = this.__M_category();
            this.__IM.onExit((Object)this, "category", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "category", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_category() {
        return "JCR";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("indexTemplate")) {
                this.__FindexTemplate = true;
            }
            if (set.contains("jcrRepository")) {
                this.__FjcrRepository = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("index")) {
                this.__Mindex = true;
            }
            if (set.contains("rebuildIndex")) {
                this.__MrebuildIndex = true;
            }
            if (set.contains("label")) {
                this.__Mlabel = true;
            }
            if (set.contains("url")) {
                this.__Murl = true;
            }
            if (set.contains("category")) {
                this.__Mcategory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

