/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.jcr.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.modeshape.jcr.api.Problems;
import org.modeshape.jcr.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.FormParameter;
import org.wisdom.api.annotations.Path;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.annotations.View;
import org.wisdom.api.annotations.scheduler.Async;
import org.wisdom.api.http.FileItem;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.jcrom.runtime.JcrRepository;
import org.wisdom.monitor.extensions.jcr.backup.BackupCreator;
import org.wisdom.monitor.service.MonitorExtension;

@Path(value="/monitor/jcr/backup")
@Authenticated(value="Monitor-Authenticator")
@Controller
public class ModeshapeJcrBackupExtension
extends DefaultController
implements MonitorExtension,
Pojo {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger(ModeshapeJcrBackupExtension.class);
    private boolean __FindexTemplate;
    @View(value="backup/index")
    Template indexTemplate;
    private boolean __FjcrRepository;
    @Requires
    JcrRepository jcrRepository;
    boolean __Mindex;
    boolean __Mbackup;
    boolean __Mrestore$org_wisdom_api_http_FileItem;
    boolean __Munzip$java_io_File$java_io_File;
    boolean __Mlabel;
    boolean __Murl;
    boolean __Mcategory;

    Template __getindexTemplate() {
        if (!this.__FindexTemplate) {
            return this.indexTemplate;
        }
        return (Template)this.__IM.onGet((Object)this, "indexTemplate");
    }

    void __setindexTemplate(Template template) {
        if (!this.__FindexTemplate) {
            this.indexTemplate = template;
            return;
        }
        this.__IM.onSet((Object)this, "indexTemplate", (Object)template);
    }

    JcrRepository __getjcrRepository() {
        if (!this.__FjcrRepository) {
            return this.jcrRepository;
        }
        return (JcrRepository)this.__IM.onGet((Object)this, "jcrRepository");
    }

    void __setjcrRepository(JcrRepository jcrRepository) {
        if (!this.__FjcrRepository) {
            this.jcrRepository = jcrRepository;
            return;
        }
        this.__IM.onSet((Object)this, "jcrRepository", (Object)jcrRepository);
    }

    public ModeshapeJcrBackupExtension() {
        this(null);
    }

    private ModeshapeJcrBackupExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Route(uri="", method=HttpMethod.GET)
    public Result index() throws Exception {
        Result result;
        if (!this.__Mindex) {
            return this.__M_index();
        }
        try {
            this.__IM.onEntry((Object)this, "index", new Object[0]);
            result = this.__M_index();
            this.__IM.onExit((Object)this, "index", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "index", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_index() throws Exception {
        return ModeshapeJcrBackupExtension.ok((Object)this.render(this.__getindexTemplate()));
    }

    @Route(uri="/create", method=HttpMethod.POST)
    @Async
    public Result backup() throws IOException {
        Result result;
        if (!this.__Mbackup) {
            return this.__M_backup();
        }
        try {
            this.__IM.onEntry((Object)this, "backup", new Object[0]);
            result = this.__M_backup();
            this.__IM.onExit((Object)this, "backup", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "backup", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_backup() throws IOException {
        BackupCreator backupCreator = new BackupCreator();
        try {
            return ModeshapeJcrBackupExtension.ok((File)backupCreator.create((Session)this.__getjcrRepository().getSession()), (boolean)true);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return ModeshapeJcrBackupExtension.internalServerError((String)e.getMessage());
        }
    }

    @Route(uri="/restore", method=HttpMethod.POST)
    @Async
    public Result restore(@FormParameter(value="upload") FileItem fileToRestore) throws IOException, RepositoryException {
        Result result;
        if (!this.__Mrestore$org_wisdom_api_http_FileItem) {
            return this.__M_restore(fileToRestore);
        }
        try {
            this.__IM.onEntry((Object)this, "restore$org_wisdom_api_http_FileItem", new Object[]{fileToRestore});
            result = this.__M_restore(fileToRestore);
            this.__IM.onExit((Object)this, "restore$org_wisdom_api_http_FileItem", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "restore$org_wisdom_api_http_FileItem", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_restore(FileItem fileToRestore) throws IOException, RepositoryException {
        File backupToRestoreFile = File.createTempFile("restore-" + new Date().getTime(), ".zip");
        InputStream inputStream = fileToRestore.stream();
        FileOutputStream outputStream = new FileOutputStream(backupToRestoreFile);
        IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        inputStream.close();
        outputStream.close();
        File backupToRestoreFolder = File.createTempFile("restore-" + new Date().getTime(), "");
        backupToRestoreFolder.delete();
        backupToRestoreFolder.mkdir();
        this.unzip(backupToRestoreFile, backupToRestoreFolder);
        Problems problems = null;
        try {
            problems = ((Session)this.__getjcrRepository().getSession()).getWorkspace().getRepositoryManager().restoreRepository(backupToRestoreFolder);
        }
        catch (RepositoryException e) {
            return ModeshapeJcrBackupExtension.internalServerError((String)("1-" + e.getMessage()));
        }
        return ModeshapeJcrBackupExtension.ok((Object)this.render(this.__getindexTemplate()));
    }

    public void unzip(File fileToUnzip, File folderToUnzipInto) {
        if (!this.__Munzip$java_io_File$java_io_File) {
            this.__M_unzip(fileToUnzip, folderToUnzipInto);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unzip$java_io_File$java_io_File", new Object[]{fileToUnzip, folderToUnzipInto});
            this.__M_unzip(fileToUnzip, folderToUnzipInto);
            this.__IM.onExit((Object)this, "unzip$java_io_File$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unzip$java_io_File$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_unzip(File fileToUnzip, File folderToUnzipInto) {
        byte[] buffer = new byte[1024];
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(fileToUnzip));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                if (ze.isDirectory()) {
                    ze = zis.getNextEntry();
                    continue;
                }
                String fileName = ze.getName();
                File newFile = new File(folderToUnzipInto + File.separator + fileName);
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String label() {
        String string;
        if (!this.__Mlabel) {
            return this.__M_label();
        }
        try {
            this.__IM.onEntry((Object)this, "label", new Object[0]);
            string = this.__M_label();
            this.__IM.onExit((Object)this, "label", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "label", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_label() {
        return "Backup Tool";
    }

    public String url() {
        String string;
        if (!this.__Murl) {
            return this.__M_url();
        }
        try {
            this.__IM.onEntry((Object)this, "url", new Object[0]);
            string = this.__M_url();
            this.__IM.onExit((Object)this, "url", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "url", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_url() {
        return "/monitor/jcr/backup";
    }

    public String category() {
        String string;
        if (!this.__Mcategory) {
            return this.__M_category();
        }
        try {
            this.__IM.onEntry((Object)this, "category", new Object[0]);
            string = this.__M_category();
            this.__IM.onExit((Object)this, "category", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "category", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_category() {
        return "JCR";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("indexTemplate")) {
                this.__FindexTemplate = true;
            }
            if (set.contains("jcrRepository")) {
                this.__FjcrRepository = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("index")) {
                this.__Mindex = true;
            }
            if (set.contains("backup")) {
                this.__Mbackup = true;
            }
            if (set.contains("restore$org_wisdom_api_http_FileItem")) {
                this.__Mrestore$org_wisdom_api_http_FileItem = true;
            }
            if (set.contains("unzip$java_io_File$java_io_File")) {
                this.__Munzip$java_io_File$java_io_File = true;
            }
            if (set.contains("label")) {
                this.__Mlabel = true;
            }
            if (set.contains("url")) {
                this.__Murl = true;
            }
            if (set.contains("category")) {
                this.__Mcategory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

