/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.jcr.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.modeshape.jcr.api.Problems;
import org.modeshape.jcr.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.monitor.extensions.jcr.backup.ModeshapeJcrBackupExtension;

public class BackupCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModeshapeJcrBackupExtension.class);

    public File create(Session session) throws Exception {
        File file = null;
        file = File.createTempFile("backup" + new Date().getTime(), "");
        file.delete();
        if (!file.mkdir()) {
            throw new IOException("Couldn't not create folder");
        }
        Problems problems = session.getWorkspace().getRepositoryManager().backupRepository(file);
        if (problems.hasProblems()) {
            String[] problemsMessage = new String[]{""};
            problems.forEach(problem -> {
                problemsMessage[0] = problemsMessage[0] + problem.getMessage();
                LOGGER.debug(problem.getMessage(), problem.getThrowable());
            });
            throw new Exception(problemsMessage[0]);
        }
        File backupArchive = File.createTempFile("backup" + new Date().getTime(), ".zip");
        BackupCreator.zip(file, backupArchive);
        return backupArchive;
    }

    public static void zip(File folderToZip, File fileToZipTo) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(fileToZipTo));){
            BackupCreator.processFolder(folderToZip, zipOutputStream, folderToZip.getPath().length() + 1);
        }
    }

    private static void processFolder(File folder, ZipOutputStream zipOutputStream, int prefixLength) throws IOException {
        for (File file : folder.listFiles()) {
            if (file.isFile()) {
                ZipEntry zipEntry = new ZipEntry(file.getPath().substring(prefixLength));
                zipOutputStream.putNextEntry(zipEntry);
                try (FileInputStream inputStream = new FileInputStream(file);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                }
                zipOutputStream.closeEntry();
                continue;
            }
            if (!file.isDirectory()) continue;
            BackupCreator.processFolder(file, zipOutputStream, prefixLength);
        }
    }
}

