/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.jcr.query;

import java.util.ArrayList;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.FormParameter;
import org.wisdom.api.annotations.Path;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.annotations.View;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.jcrom.runtime.JcrRepository;
import org.wisdom.monitor.service.MonitorExtension;

@Path(value="/monitor/jcr/query")
@Authenticated(value="Monitor-Authenticator")
@Controller
public class JcrQueryExtension
extends DefaultController
implements MonitorExtension,
Pojo {
    InstanceManager __IM;
    boolean __MRowValues___getValues;
    boolean __MRowValues___getNodes;
    private boolean __FqueryTemplate;
    @View(value="query/query")
    Template queryTemplate;
    private boolean __FjcrRepository;
    @Requires
    JcrRepository jcrRepository;
    boolean __Mlabel;
    boolean __Mindex;
    boolean __MgetLanguages;
    boolean __Mresult$java_lang_String$java_lang_String$javax_jcr_query_QueryResult$java_lang_Exception;
    boolean __Mexecute$java_lang_String$java_lang_String;
    boolean __Murl;
    boolean __Mcategory;

    Template __getqueryTemplate() {
        if (!this.__FqueryTemplate) {
            return this.queryTemplate;
        }
        return (Template)this.__IM.onGet((Object)this, "queryTemplate");
    }

    void __setqueryTemplate(Template template) {
        if (!this.__FqueryTemplate) {
            this.queryTemplate = template;
            return;
        }
        this.__IM.onSet((Object)this, "queryTemplate", (Object)template);
    }

    JcrRepository __getjcrRepository() {
        if (!this.__FjcrRepository) {
            return this.jcrRepository;
        }
        return (JcrRepository)this.__IM.onGet((Object)this, "jcrRepository");
    }

    void __setjcrRepository(JcrRepository jcrRepository) {
        if (!this.__FjcrRepository) {
            this.jcrRepository = jcrRepository;
            return;
        }
        this.__IM.onSet((Object)this, "jcrRepository", (Object)jcrRepository);
    }

    public JcrQueryExtension() {
        this(null);
    }

    private JcrQueryExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public String label() {
        String string;
        if (!this.__Mlabel) {
            return this.__M_label();
        }
        try {
            this.__IM.onEntry((Object)this, "label", new Object[0]);
            string = this.__M_label();
            this.__IM.onExit((Object)this, "label", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "label", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_label() {
        return "Query";
    }

    @Route(uri="", method=HttpMethod.GET)
    public Result index() throws Exception {
        Result result;
        if (!this.__Mindex) {
            return this.__M_index();
        }
        try {
            this.__IM.onEntry((Object)this, "index", new Object[0]);
            result = this.__M_index();
            this.__IM.onExit((Object)this, "index", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "index", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_index() throws Exception {
        return this.result("", "", null, null);
    }

    private String[] getLanguages() throws RepositoryException {
        String[] stringArray;
        if (!this.__MgetLanguages) {
            return this.__M_getLanguages();
        }
        try {
            this.__IM.onEntry((Object)this, "getLanguages", new Object[0]);
            stringArray = this.__M_getLanguages();
            this.__IM.onExit((Object)this, "getLanguages", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getLanguages", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __M_getLanguages() throws RepositoryException {
        return this.__getjcrRepository().getSession().getWorkspace().getQueryManager().getSupportedQueryLanguages();
    }

    private Result result(String query, String language, QueryResult result, Exception exception) throws RepositoryException {
        Result result2;
        if (!this.__Mresult$java_lang_String$java_lang_String$javax_jcr_query_QueryResult$java_lang_Exception) {
            return this.__M_result(query, language, result, exception);
        }
        try {
            this.__IM.onEntry((Object)this, "result$java_lang_String$java_lang_String$javax_jcr_query_QueryResult$java_lang_Exception", new Object[]{query, language, result, exception});
            result2 = this.__M_result(query, language, result, exception);
            this.__IM.onExit((Object)this, "result$java_lang_String$java_lang_String$javax_jcr_query_QueryResult$java_lang_Exception", (Object)result2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "result$java_lang_String$java_lang_String$javax_jcr_query_QueryResult$java_lang_Exception", throwable);
            throw throwable;
        }
        return result2;
    }

    private Result __M_result(String query, String language, QueryResult result, Exception exception) throws RepositoryException {
        ArrayList<RowValues> rows = null;
        if (result != null) {
            RowIterator rowIterator = result.getRows();
            rows = new ArrayList<RowValues>((int)rowIterator.getSize());
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                RowValues rowValues = new RowValues();
                rowValues.values = row.getValues();
                int selectorsSize = result.getSelectorNames().length;
                if (selectorsSize > 0) {
                    rowValues.nodes = new Node[selectorsSize];
                    int i = 0;
                    for (String selector : result.getSelectorNames()) {
                        rowValues.nodes[i] = row.getNode(selector);
                        ++i;
                    }
                } else {
                    rowValues.nodes = new Node[]{row.getNode()};
                }
                rows.add(rowValues);
            }
        }
        return JcrQueryExtension.ok((Object)this.render(this.__getqueryTemplate(), new Object[]{"query", query, "language", language, "languages", this.getLanguages(), "result", result, "rows", rows, "exception", exception}));
    }

    @Route(uri="/execute", method=HttpMethod.POST)
    public Result execute(@FormParameter(value="query") String query, @FormParameter(value="language") String language) throws Exception {
        Result result;
        if (!this.__Mexecute$java_lang_String$java_lang_String) {
            return this.__M_execute(query, language);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$java_lang_String$java_lang_String", new Object[]{query, language});
            result = this.__M_execute(query, language);
            this.__IM.onExit((Object)this, "execute$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result __M_execute(String query, String language) throws Exception {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Query createdQuery = this.__getjcrRepository().getSession().getWorkspace().getQueryManager().createQuery(query, language);
            QueryResult result = createdQuery.execute();
            Result result2 = this.result(query, language, result, null);
            Thread.currentThread().setContextClassLoader(original);
            return result2;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(original);
                throw throwable;
            }
            catch (Exception e) {
                return this.result(query, language, null, e);
            }
        }
    }

    public String url() {
        String string;
        if (!this.__Murl) {
            return this.__M_url();
        }
        try {
            this.__IM.onEntry((Object)this, "url", new Object[0]);
            string = this.__M_url();
            this.__IM.onExit((Object)this, "url", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "url", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_url() {
        return "/monitor/jcr/query";
    }

    public String category() {
        String string;
        if (!this.__Mcategory) {
            return this.__M_category();
        }
        try {
            this.__IM.onEntry((Object)this, "category", new Object[0]);
            string = this.__M_category();
            this.__IM.onExit((Object)this, "category", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "category", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_category() {
        return "JCR";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("jcrRepository")) {
                this.__FjcrRepository = true;
            }
            if (set.contains("queryTemplate")) {
                this.__FqueryTemplate = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("RowValues___getValues")) {
                this.__MRowValues___getValues = true;
            }
            if (set.contains("RowValues___getNodes")) {
                this.__MRowValues___getNodes = true;
            }
            if (set.contains("label")) {
                this.__Mlabel = true;
            }
            if (set.contains("index")) {
                this.__Mindex = true;
            }
            if (set.contains("getLanguages")) {
                this.__MgetLanguages = true;
            }
            if (set.contains("result$java_lang_String$java_lang_String$javax_jcr_query_QueryResult$java_lang_Exception")) {
                this.__Mresult$java_lang_String$java_lang_String$javax_jcr_query_QueryResult$java_lang_Exception = true;
            }
            if (set.contains("execute$java_lang_String$java_lang_String")) {
                this.__Mexecute$java_lang_String$java_lang_String = true;
            }
            if (set.contains("url")) {
                this.__Murl = true;
            }
            if (set.contains("category")) {
                this.__Mcategory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    class RowValues {
        Value[] values;
        Node[] nodes;

        RowValues() {
        }

        public Value[] getValues() {
            Value[] valueArray;
            if (!JcrQueryExtension.this.__MRowValues___getValues) {
                return this.__M_getValues();
            }
            try {
                JcrQueryExtension.this.__IM.onEntry((Object)this, "RowValues___getValues", new Object[0]);
                valueArray = this.__M_getValues();
                JcrQueryExtension.this.__IM.onExit((Object)this, "RowValues___getValues", (Object)valueArray);
            }
            catch (Throwable throwable) {
                JcrQueryExtension.this.__IM.onError((Object)this, "RowValues___getValues", throwable);
                throw throwable;
            }
            return valueArray;
        }

        private Value[] __M_getValues() {
            return this.values;
        }

        public Node[] getNodes() {
            Node[] nodeArray;
            if (!JcrQueryExtension.this.__MRowValues___getNodes) {
                return this.__M_getNodes();
            }
            try {
                JcrQueryExtension.this.__IM.onEntry((Object)this, "RowValues___getNodes", new Object[0]);
                nodeArray = this.__M_getNodes();
                JcrQueryExtension.this.__IM.onExit((Object)this, "RowValues___getNodes", (Object)nodeArray);
            }
            catch (Throwable throwable) {
                JcrQueryExtension.this.__IM.onError((Object)this, "RowValues___getNodes", throwable);
                throw throwable;
            }
            return nodeArray;
        }

        private Node[] __M_getNodes() {
            return this.nodes;
        }
    }
}

