/*
 * Decompiled with CFR 0.152.
 */
package org.uqbarproject.jpa.java8.extras.convert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class LambdaConverter
implements AttributeConverter<Object, byte[]> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] convertToDatabaseColumn(Object lambda) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(out);){
            objectOutputStream.writeObject(lambda);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object convertToEntityAttribute(byte[] lambdaClassBytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(lambdaClassBytes);
        try (ObjectInputStream objectInputStream = new ObjectInputStream(in);){
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

