package ar.edu.celulares.domain;

import java.math.BigDecimal;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;
import org.uqbar.commons.model.Entity;
import org.uqbar.commons.utils.Observable;

@Accessors
@Observable
@SuppressWarnings("all")
public class Modelo extends Entity {
  private String descripcion;
  
  private BigDecimal costo;
  
  private Boolean requiereResumenCuenta;
  
  public String getDescripcionEntera() {
    String _concat = this.descripcion.concat(" ($ ");
    String _string = this.costo.toString();
    String _concat_1 = _concat.concat(_string);
    return _concat_1.concat(")");
  }
  
  public String toString() {
    return this.getDescripcionEntera();
  }
  
  @Pure
  public String getDescripcion() {
    return this.descripcion;
  }
  
  public void setDescripcion(final String descripcion) {
    this.descripcion = descripcion;
  }
  
  @Pure
  public BigDecimal getCosto() {
    return this.costo;
  }
  
  public void setCosto(final BigDecimal costo) {
    this.costo = costo;
  }
  
  @Pure
  public Boolean getRequiereResumenCuenta() {
    return this.requiereResumenCuenta;
  }
  
  public void setRequiereResumenCuenta(final Boolean requiereResumenCuenta) {
    this.requiereResumenCuenta = requiereResumenCuenta;
  }
}
