package ar.edu.celulares.domain;

import ar.edu.celulares.domain.Modelo;
import com.google.common.base.Objects;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.uqbar.commons.model.Entity;
import org.uqbar.commons.model.ObservableUtils;
import org.uqbar.commons.model.UserException;
import org.uqbar.commons.utils.Observable;

@Accessors
@Observable
@SuppressWarnings("all")
public class Celular extends Entity implements Cloneable {
  private final int MAX_NUMERO = 100000;
  
  private Integer id;
  
  private Integer numero;
  
  private String nombre;
  
  private Modelo modeloCelular;
  
  private Boolean recibeResumenCuenta = Boolean.valueOf(false);
  
  public void setModeloCelular(final Modelo unModeloCelular) {
    this.modeloCelular = unModeloCelular;
    Boolean _requiereResumenCuenta = unModeloCelular.getRequiereResumenCuenta();
    this.recibeResumenCuenta = _requiereResumenCuenta;
    boolean _isHabilitaResumenCuenta = this.isHabilitaResumenCuenta();
    ObservableUtils.firePropertyChanged(this, "habilitaResumenCuenta", Boolean.valueOf(_isHabilitaResumenCuenta));
  }
  
  /**
   * Valida que el celular esté correctamente cargado
   */
  public void validar() {
    boolean _equals = Objects.equal(this.numero, null);
    if (_equals) {
      throw new UserException("Debe ingresar número");
    }
    int _intValue = this.numero.intValue();
    boolean _lessEqualsThan = (_intValue <= this.MAX_NUMERO);
    if (_lessEqualsThan) {
      throw new UserException(("El número debe ser mayor a " + Integer.valueOf(this.MAX_NUMERO)));
    }
    boolean _ingresoNombre = this.ingresoNombre();
    boolean _not = (!_ingresoNombre);
    if (_not) {
      throw new UserException("Debe ingresar nombre");
    }
    boolean _equals_1 = Objects.equal(this.modeloCelular, null);
    if (_equals_1) {
      throw new UserException("Debe ingresar un modelo de celular");
    }
  }
  
  public boolean ingresoNombre() {
    boolean _and = false;
    boolean _notEquals = (!Objects.equal(this.nombre, null));
    if (!_notEquals) {
      _and = false;
    } else {
      String _trim = this.nombre.trim();
      boolean _equals = _trim.equals("");
      boolean _not = (!_equals);
      _and = _not;
    }
    return _and;
  }
  
  public boolean isHabilitaResumenCuenta() {
    Boolean _requiereResumenCuenta = this.modeloCelular.getRequiereResumenCuenta();
    return (!(_requiereResumenCuenta).booleanValue());
  }
  
  public String toString() {
    String _xblockexpression = null;
    {
      StringBuffer result = new StringBuffer();
      String _elvis = null;
      if (this.nombre != null) {
        _elvis = this.nombre;
      } else {
        _elvis = "Celular sin nombre";
      }
      result.append(_elvis);
      boolean _notEquals = (!Objects.equal(this.modeloCelular, null));
      if (_notEquals) {
        result.append((" - " + this.modeloCelular));
      }
      boolean _notEquals_1 = (!Objects.equal(this.numero, null));
      if (_notEquals_1) {
        result.append((" - " + this.numero));
      }
      String _xifexpression = null;
      if ((this.recibeResumenCuenta).booleanValue()) {
        _xifexpression = " - recibe resumen";
      } else {
        _xifexpression = " - no recibe resumen";
      }
      result.append(_xifexpression);
      _xblockexpression = result.toString();
    }
    return _xblockexpression;
  }
  
  public Object clone() {
    try {
      return super.clone();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public Modelo copiarA(final Celular destino) {
    Modelo _xblockexpression = null;
    {
      destino.numero = this.numero;
      destino.nombre = this.nombre;
      destino.recibeResumenCuenta = this.recibeResumenCuenta;
      _xblockexpression = destino.modeloCelular = this.modeloCelular;
    }
    return _xblockexpression;
  }
  
  @Pure
  public int getMAX_NUMERO() {
    return this.MAX_NUMERO;
  }
  
  @Pure
  public Integer getId() {
    return this.id;
  }
  
  public void setId(final Integer id) {
    this.id = id;
  }
  
  @Pure
  public Integer getNumero() {
    return this.numero;
  }
  
  public void setNumero(final Integer numero) {
    this.numero = numero;
  }
  
  @Pure
  public String getNombre() {
    return this.nombre;
  }
  
  public void setNombre(final String nombre) {
    this.nombre = nombre;
  }
  
  @Pure
  public Modelo getModeloCelular() {
    return this.modeloCelular;
  }
  
  @Pure
  public Boolean getRecibeResumenCuenta() {
    return this.recibeResumenCuenta;
  }
  
  public void setRecibeResumenCuenta(final Boolean recibeResumenCuenta) {
    this.recibeResumenCuenta = recibeResumenCuenta;
  }
}
