package ar.edu.celulares.applicationModel;

import ar.edu.celulares.domain.Celular;
import ar.edu.celulares.home.HomeCelulares;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;
import org.uqbar.commons.utils.ApplicationContext;
import org.uqbar.commons.utils.Observable;

/**
 * Application model que representa la búsqueda de {@link Celular}.
 * Contiene:
 * <ul>
 * 	<li>El estado de los atributos por los cuales buscar: numero y nombre</li>
 *  <li>El comportamiento para realizar la búsqueda (en realidad delega en otros objetos)</li>
 *  <li>El estado del resultado de la búsqueda, es decir que recuerda la lista de Celulares resultado</li>
 *  <li>El estado de la selección de un Celular para poder utilizar el comportamiento que sigue...</li>
 *  <li>Comportamiento para eliminar un Celular seleccionado.</li>
 * </ul>
 * 
 * Este es un objeto transiente, que contiene estado de la ejecución para un usuario en particular
 * en una ejecución de la aplicación en particular.
 * 
 * @author npasserini
 */
@Accessors
@Observable
@SuppressWarnings("all")
public class BuscadorCelular implements Serializable {
  private Integer numero;
  
  private String nombre;
  
  private List<Celular> resultados;
  
  private Celular celularSeleccionado;
  
  public void search() {
    ArrayList<Celular> _arrayList = new ArrayList<Celular>();
    this.resultados = _arrayList;
    HomeCelulares _homeCelulares = this.getHomeCelulares();
    List<Celular> _search = _homeCelulares.search(this.numero, this.nombre);
    this.resultados = _search;
  }
  
  public void clear() {
    this.nombre = null;
    this.numero = null;
  }
  
  public void eliminarCelularSeleccionado() {
    HomeCelulares _homeCelulares = this.getHomeCelulares();
    _homeCelulares.delete(this.celularSeleccionado);
    this.search();
    this.celularSeleccionado = null;
  }
  
  public HomeCelulares getHomeCelulares() {
    ApplicationContext _instance = ApplicationContext.getInstance();
    return _instance.<HomeCelulares>getSingleton(Celular.class);
  }
  
  @Pure
  public Integer getNumero() {
    return this.numero;
  }
  
  public void setNumero(final Integer numero) {
    this.numero = numero;
  }
  
  @Pure
  public String getNombre() {
    return this.nombre;
  }
  
  public void setNombre(final String nombre) {
    this.nombre = nombre;
  }
  
  @Pure
  public List<Celular> getResultados() {
    return this.resultados;
  }
  
  public void setResultados(final List<Celular> resultados) {
    this.resultados = resultados;
  }
  
  @Pure
  public Celular getCelularSeleccionado() {
    return this.celularSeleccionado;
  }
  
  public void setCelularSeleccionado(final Celular celularSeleccionado) {
    this.celularSeleccionado = celularSeleccionado;
  }
}
