package org.uqbar.arena.examples.conversor.xtend.typesafe;

import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure0;
import org.uqbar.arena.examples.conversor.xtend.typesafe.DistanceConverter;
import org.uqbar.arena.layout.VerticalLayout;
import org.uqbar.arena.widgets.Panel;
import org.uqbar.arena.windows.MainWindow;
import org.uqbar.arena.xtend.ArenaXTendFactory;

/**
 * miles -> kilometers converter.
 */
@SuppressWarnings("all")
public class TypeSafeDistanceConverterWindow extends MainWindow<DistanceConverter> {
  @Extension
  private ArenaXTendFactory _arenaXTendFactory = new ArenaXTendFactory();
  
  public TypeSafeDistanceConverterWindow() {
    super(new DistanceConverter());
  }
  
  public void createContents(final Panel mainPanel) {
    this.setTitle("Miles To Kilometer Converter");
    VerticalLayout _verticalLayout = new VerticalLayout();
    mainPanel.setLayout(_verticalLayout);
    this._arenaXTendFactory.asLabel("Input in miles", mainPanel);
    final Function1<DistanceConverter, Double> _function = new Function1<DistanceConverter, Double>() {
      public Double apply(final DistanceConverter it) {
        return it.getMiles();
      }
    };
    Function1<DistanceConverter, Double> _binding = this._arenaXTendFactory.<DistanceConverter, Double>binding(this, _function);
    this._arenaXTendFactory.<DistanceConverter, Double>asTextBoxIn(_binding, mainPanel);
    final Procedure0 _function_1 = new Procedure0() {
      public void apply() {
        DistanceConverter _modelObject = TypeSafeDistanceConverterWindow.this.getModelObject();
        _modelObject.convert();
      }
    };
    Pair<String, Procedure0> _mappedTo = Pair.<String, Procedure0>of("Convert", _function_1);
    this._arenaXTendFactory.asButtonIn(_mappedTo, mainPanel);
    final Function1<DistanceConverter, Double> _function_2 = new Function1<DistanceConverter, Double>() {
      public Double apply(final DistanceConverter it) {
        return it.getKilometers();
      }
    };
    Function1<DistanceConverter, Double> _binding_1 = this._arenaXTendFactory.<DistanceConverter, Double>binding(this, _function_2);
    this._arenaXTendFactory.<DistanceConverter, Double>asLabelIn(_binding_1, mainPanel);
    this._arenaXTendFactory.asLabel(" km", mainPanel);
  }
  
  public static void main(final String[] args) {
    TypeSafeDistanceConverterWindow _typeSafeDistanceConverterWindow = new TypeSafeDistanceConverterWindow();
    _typeSafeDistanceConverterWindow.startApplication();
  }
}
