package org.uqbar.arena.xtend;

import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.uqbar.arena.bindings.ObservableProperty;
import org.uqbar.arena.widgets.Widget;
import org.uqbar.arena.xtend.ArenaTypeSafeBindingExtensions;
import org.uqbar.lacar.ui.model.WidgetBuilder;
import org.uqbar.lacar.ui.model.bindings.Binding;
import org.uqbar.lacar.ui.model.bindings.Observable;
import org.uqbar.lacar.ui.model.bindings.ViewObservable;

/**
 * Extension methods for Arena.
 * Usually operator overloading and methods for using Arena
 * with a sort of internal DSL. For example for bindings.
 * 
 * @author jfernandes
 */
@SuppressWarnings("all")
public class ArenaXtendExtensions {
  public static Binding operator_spaceship(final ViewObservable value, final String property) {
    Widget _view = value.getView();
    Object _containerModelObject = _view.<Object>getContainerModelObject();
    ObservableProperty<Object> _observableProperty = new ObservableProperty<Object>(((Object) _containerModelObject), property);
    return value.<Object>bindTo(_observableProperty);
  }
  
  public static <M extends Object, R extends Object> Binding operator_spaceship(final ViewObservable obs, final Function1<M, R> propertyBinder) {
    Widget _view = obs.getView();
    Object _containerModelObject = _view.<Object>getContainerModelObject();
    String _calculateObservable = ArenaTypeSafeBindingExtensions.<M, R>calculateObservable(_containerModelObject, propertyBinder);
    return ArenaXtendExtensions.operator_spaceship(obs, _calculateObservable);
  }
  
  public static Binding<Object, Widget, WidgetBuilder> bindTo(final ViewObservable viewAttribute, final Observable model) {
    Widget _view = viewAttribute.getView();
    return _view.<Object, Widget, WidgetBuilder>addBinding(model, viewAttribute);
  }
}
