package org.uqbar.arena.xtend;

import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure0;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.uqbar.arena.widgets.Button;
import org.uqbar.arena.widgets.Label;
import org.uqbar.arena.widgets.Panel;
import org.uqbar.arena.widgets.Selector;
import org.uqbar.arena.widgets.TextBox;
import org.uqbar.arena.windows.Window;
import org.uqbar.arena.xtend.ArenaTypeSafeBindingExtensions;
import org.uqbar.lacar.ui.model.Action;

/**
 * Extension as factory methods to create arena applications
 * as a kind of internal DSL.
 * 
 * @author jfernandes
 */
@SuppressWarnings("all")
public class ArenaXTendFactory {
  @Extension
  private ArenaTypeSafeBindingExtensions _arenaTypeSafeBindingExtensions = new ArenaTypeSafeBindingExtensions();
  
  public <M extends Object, R extends Object> Function1<M, R> binding(final Window<M> window, final Function1<M, R> function1) {
    return function1;
  }
  
  public Label asLabel(final String string, final Panel panel) {
    Label _label = new Label(panel);
    return _label.setText(string);
  }
  
  public <M extends Object, R extends Object> TextBox asTextBoxIn(final Function1<M, R> binding, final Panel panel) {
    TextBox _textBox = new TextBox(panel);
    final Procedure1<TextBox> _function = new Procedure1<TextBox>() {
      public void apply(final TextBox it) {
        ArenaXTendFactory.this._arenaTypeSafeBindingExtensions.<M, R>bindValue(it, binding);
      }
    };
    return ObjectExtensions.<TextBox>operator_doubleArrow(_textBox, _function);
  }
  
  public <M extends Object, R extends Object> Selector<R> asSelectorIn(final Function1<M, R> binding, final Panel panel) {
    Selector<R> _selector = new Selector<R>(panel);
    final Procedure1<Selector<R>> _function = new Procedure1<Selector<R>>() {
      public void apply(final Selector<R> it) {
        ArenaXTendFactory.this._arenaTypeSafeBindingExtensions.<M, R>bindValue(it, binding);
      }
    };
    return ObjectExtensions.<Selector<R>>operator_doubleArrow(_selector, _function);
  }
  
  public <M extends Object, R extends Object> Label asLabelIn(final Function1<M, R> binding, final Panel panel) {
    Label _label = new Label(panel);
    final Procedure1<Label> _function = new Procedure1<Label>() {
      public void apply(final Label it) {
        ArenaXTendFactory.this._arenaTypeSafeBindingExtensions.<M, R>bindValue(it, binding);
      }
    };
    return ObjectExtensions.<Label>operator_doubleArrow(_label, _function);
  }
  
  public Button asButtonIn(final Pair<String, Procedure0> captionAndAction, final Panel panel) {
    Button _xblockexpression = null;
    {
      final Procedure0 onC = captionAndAction.getValue();
      Button _button = new Button(panel);
      final Procedure1<Button> _function = new Procedure1<Button>() {
        public void apply(final Button it) {
          String _key = captionAndAction.getKey();
          it.setCaption(_key);
          it.onClick(new Action() {
              public void execute() {
                onC.apply();
              }
          });
        }
      };
      _xblockexpression = ObjectExtensions.<Button>operator_doubleArrow(_button, _function);
    }
    return _xblockexpression;
  }
}
